package risiko.common.interfaces;

import java.awt.Color;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface zum Valueobject
 * 
 * @author dgrosche
 * @version 2009-07-01
 *
 */
public interface Land extends Remote, Serializable {

	/**
	 * @param name the name to set
	 */
	public abstract void setName(String name) throws RemoteException;

	/**
	 * @return the name
	 */
	public abstract String getName() throws RemoteException;

	/**
	 * @param besitzer the besitzer to set
	 */
	public abstract void setBesitzer(Spieler besitzer) throws RemoteException;

	/**
	 * @return the besitzer
	 */
	public abstract Spieler getBesitzer() throws RemoteException;

	/**
	 * @param anzEinheiten the anzEinheiten to set
	 */
	public abstract void setAnzEinheiten(int anzEinheiten) throws RemoteException;

	/**
	 * @return the anzEinheiten
	 */
	public abstract int getAnzEinheiten() throws RemoteException;

	/**
	 * @param farbe the farbe to set
	 */
	public abstract void setFarbe(Color farbe) throws RemoteException;

	/**
	 * @return the farbe
	 */
	public abstract Color getFarbe() throws RemoteException;

	/**
	 * @param beteiligt the beteiligt to set
	 */
	public abstract void setBeteiligt(boolean beteiligt) throws RemoteException;

	/**
	 * @return the beteiligt
	 */
	public abstract boolean isBeteiligt() throws RemoteException;

	/**
	 * @return the nummer
	 */
	public abstract int getNummer() throws RemoteException;
	
	/**
	 * @return Land als String
	 */
	public abstract String getString() throws RemoteException;

	/**
	 * @return Alle Informationen des Landes (3zeilig)
	 */
	public abstract String getInfos() throws RemoteException;

}