package risiko.common.interfaces;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;

/**
 * Interface zum Valueobject
 * 
 * @author dgrosche
 * @version 2009-07-01
 *
 */
public interface KontinentMission extends Remote, Serializable {

	/**
	 * Fgt Kontinenten zur Liste zu befreiender Kontinente hinzu
	 * 
	 * @param k hinzuzufgender Kontinent
	 */
	public abstract void addKontinent(Kontinent k) throws RemoteException;

	/**
	 * @param kliste the kontinentenliste to set
	 */
	public abstract void setKontinentenliste(Vector<Kontinent> kliste) throws RemoteException;

	public abstract void pruefErfuellt() throws RemoteException;

}