package risiko.common.interfaces;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;

/**
 * Interface zum Valueobject
 * 
 * @author dgrosche
 * @version 2009-07-01
 *
 */
public interface BefreiungsMission extends Remote, Serializable {

	/**
	 * @param spielerliste Liste mit mit allen Spielern
	 */
	public abstract void setSpielerliste(Vector<Spieler> spielerliste) throws RemoteException;

	public abstract void pruefErfuellt() throws RemoteException;

	/**
	 * @return Spieler der besiegt werden soll
	 */
	public abstract Spieler getFeind() throws RemoteException;

}