package risiko.common.exceptions;

import java.util.Vector;

/**
 * Spieler versucht mit mehr Einheiten anzugreifen, als er Wrfel zur Verfgung hat
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class NichtGenugWuerfelException extends Exception {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -417686531441539465L;

	private int wuerfelanz;
	private Vector<Integer> wuerfel;
	
	/**
	 * Konstruktor
	 * 
	 * @param x Anzahl der Einheiten mit denen angegriffen wird
	 * @param i Anzahl der Wrfel die zur Verfgung stehen
	 * @param wA Wrfelzahlen des Angreifers
	 */
	public NichtGenugWuerfelException(int x, int i, Vector<Integer> wA) {
		super("FEHLER: Sie wollen "+x+" Einheiten einsetzen, haben aber nur "+i+" Wrfel zur Verfgung");
		wuerfelanz = i;
		wuerfel = wA;
	}
	
	/**
	 * Gibt zurck, ob der Fehler beim Angreifer oder Verteidiger auftritt
	 * und lscht bei Bedarf Wrfelzahlen des Angreifers
	 * 
	 * @return true, wenn Fehler beim Angreifer
	 */
	public boolean behandle() {
		if(this.wuerfelanz==3) {
			return true;
		} else {
			wuerfel.removeAllElements();
			return false;
		}
	}

}
