package risiko.common.exceptions;

import java.rmi.RemoteException;

import risiko.common.interfaces.Land;
import risiko.common.interfaces.Spieler;

/**
 * Land gehrt nicht dem aktiven Spieler
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class LandNichtImBesitzException extends Exception {

	/**
	 * Konstruktor
	 * 
	 * @param a Land das nicht im Besitz des aktiven Spielers ist
	 * @param aktiverSpieler aktiver Spieler
	 * @throws RemoteException 
	 */
	public LandNichtImBesitzException(Land a, Spieler aktiverSpieler) throws RemoteException {
		super(a.getName() +" ist im Besitz von "+a.getBesitzer().getName()+", nicht von "+aktiverSpieler.getName()+".");
	}

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -9196935268950469979L;

}
