package risiko.client.ui.gui;

import java.awt.Dimension;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

import risiko.common.interfaces.Land;

/**
 * Welt-Panel mit der Hintergrundkarte, den einzelnen Lnderlabels
 * und der Beziehungsmaske
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public abstract class WeltPanel {
	
	private static JPanel weltPanel; //Das Panel an sich
	private static Hashtable<Land,JLand> laender; //Die Lnderlabels
	private static JLabel beziehungsmaske; //Die Beziehungsmaske
	
	/**
	 * Das Hintergrundbild mit der Farbkarte zum erkennen des Landes
	 */
	protected static Hintergrundbild klickBild;
	
	/**
	 * Das Welt-Panel wird erstellt
	 * 
	 * @return WeltPanel
	 * @throws IOException wenn Problem mit dem Hintergrund-Klickbild
	 */
	protected static JPanel create() throws IOException {
		beziehungsmaske = new JLabel();
		JPanel thisPanel = new JPanel(null);
		thisPanel.setPreferredSize(new Dimension(1024, 559));
		thisPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));      

		klickBild = new Hintergrundbild();
		klickBild.setBounds(0, 0, 1024, 559);	
		klickBild.setOpaque(true);
		thisPanel.add(klickBild);

        weltPanel = thisPanel;
        return thisPanel;
        
	}
	
	/**
	 * @param laenderliste the laenderkiste to set
	 * @throws RemoteException 
	 */
	protected static void setLaender(Vector<Land> laenderliste) throws RemoteException {
		laender = new Hashtable<Land, JLand>();
		for(Land l : laenderliste) {
			laender.put(l,new JLand(l));
		}
	}
	
	/**
	 * Tauscht das Icon des Labels des Landes durch die gehighlightete Version aus 
	 * 
	 * @param l Land, das gehighlightet wird.
	 * @throws RemoteException 
	 */
	protected static void highlighte(Land l) throws RemoteException {
		weltPanel.remove(laender.get(l));
		laender.remove(l);
		laender.put(l,new JLand(l));
		laender.get(l).highlighte();
		weltPanel.add(laender.get(l),0);
		weltPanel.repaint();
	}
	
	/**
	 * Tauscht das Icon des Lnderlabels aus und fgt Beziehungsmaske hinzu
	 * 
	 * @param l Land, das gehighlightet wird.
	 * @throws RemoteException 
	 */
	protected static void highlighteVoll(Land l) throws RemoteException {
		highlighte(l);
		beziehungsmaske = new JLabel(new ImageIcon("images/BEZ_"+l.getNummer()+".png"));
		beziehungsmaske.setBounds(0,0,1024,559);
		weltPanel.add(beziehungsmaske,0);
		weltPanel.repaint();
	}
	
	/**
	 * Alle Lnderlabels werden in den Normalzustand gesetzt und aktualisiert.
	 * Die Beziehungsmaske wird entfernt.
	 * @throws RemoteException 
	 */
	protected static void aktualisiere() throws RemoteException {
		weltPanel.remove(beziehungsmaske);
		Collection<JLand> labels = laender.values();
		for(JLand l : labels) {
			l.aktualisiere();
		}
		weltPanel.repaint();
	}
	
	/**
	 * Die Lnder werden zu Beginn alle gezeichnet
	 */
	protected static void zeichneLaender() {
        Collection<JLand> labels = laender.values();
        for(JLand l : labels) {
        	weltPanel.add(l,0);
        }
        weltPanel.repaint();
	}

}
