package risiko.client.ui.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

/**
 * Das MenuPanel beinhaltet smtliche Panels fr Benutzereingaben als 
 * Karten eines KartenLayout-Panels
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public class MenuPanel {
	
	private static CardLayout cards; //Das KartenLayout des Panels
	private static Font batman; //Der Spezialfont des Panels
	private static JPopupMenu popup; //Das Popupmenu zum Laden und Speichern
	private static GridBagConstraints constraints;
	
	/**
	 * Buttons der Hauptmenus
	 */
	protected static JButton angriffButton, verschiebeButton, beendenButton;
	
	/**
	 * Starten-Buttons der Panel
	 */
	protected static Hashtable<String,JButton> starten;
	
	/**
	 * Anzahl-Spinner der Panels
	 */
	protected static Hashtable<String,JSpinner> anzahl;
	
	/**
	 * Textfelder mit Ursprungs- und Ziellnder der Panels
	 */
	protected static Hashtable<String,JTextField> ursprung, ziel;
	
	/**
	 * Speichern und Laden im Popupmenu
	 */
	protected static JMenuItem speichern, laden;
	
	/**
	 * Erstellt das MenuPanel
	 * @return MenuPanel
	 */
	protected static JPanel create() {
		
		cards = new CardLayout();
		JPanel thisPanel = new JPanel(cards);
		thisPanel.setOpaque(false);
        
		try {
			batman = Font.createFont(Font.PLAIN, new File("batman.ttf"));
		} catch (FontFormatException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		} catch (IOException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		}
        thisPanel.setFont(batman.deriveFont(Font.PLAIN, 12));
        
        starten = new Hashtable<String, JButton>();
        anzahl = new Hashtable<String, JSpinner>();
        ursprung = new Hashtable<String, JTextField>();
        ziel = new Hashtable<String, JTextField>();
        
        thisPanel.add(erstelleHauptPanel(),"Haupt");
        thisPanel.add(erstelleAngriffsPanel(),"Angriff");
        thisPanel.add(erstelleTransferPanel(),"Transfer");
        thisPanel.add(erstelleVerteidigungsPanel(),"Verteidigung");
        thisPanel.add(erstelleVerstaerkungsPanel(),"Verstaerkung");
        thisPanel.add(erstelleLogoPanel(),"Leer");
                
        cards.show(thisPanel, "Leer");
        
        return thisPanel;
        
	}
	
	/**
	 * Erstellt das Hauptmen-Panel
	 * @return Hauptmen-Panel
	 */
	private static JPanel erstelleHauptPanel() {
		
		JPanel returnPanel = new JPanel(new GridBagLayout());
		returnPanel.setOpaque(false);
        
		//Die Komponenten werden erstellt
		angriffButton = new JButton("Angriff starten");
        verschiebeButton = new JButton("Einheiten verschieben");
        beendenButton = new JButton("Zug beenden");
        
        //Die Komponenten werden formatiert
        angriffButton.setFont(batman.deriveFont(Font.PLAIN, 14));        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;		// 0. Spalte
        constraints.gridy = 0;		// 0. Zeile
        constraints.insets = new Insets(10,100,10,100);	// Rnder(oben,links,unten,rechts)
        constraints.fill = GridBagConstraints.HORIZONTAL;	// Horizontal ausfllen  	
        returnPanel.add(angriffButton, constraints);
        
        verschiebeButton.setFont(batman.deriveFont(Font.PLAIN, 14));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;		// 0. Spalte
        constraints.gridy = 1;		// 1. Zeile
        constraints.insets = new Insets(10,100,10,100);	// Rnder(oben,links,unten,rechts)
        constraints.fill = GridBagConstraints.HORIZONTAL;	// Horizontal ausfllen
        returnPanel.add(verschiebeButton, constraints);

        beendenButton.setFont(batman.deriveFont(Font.PLAIN, 14));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;		// 0. Spalte
        constraints.gridy = 2;		// 2. Zeile
        constraints.insets = new Insets(10,100,10,100);	// Rnder(oben,links,unten,rechts)
        constraints.fill = GridBagConstraints.HORIZONTAL;	// Horizontal ausfllen
        returnPanel.add(beendenButton, constraints);
        
        //Popmenu wird erstellt
        popup = new JPopupMenu();
        speichern = new JMenuItem("Spielstand speichern");
        popup.add(speichern);
//        laden = new JMenuItem("Spielstand laden");
//        popup.add(laden);
        
        MenuPanel menu = new MenuPanel();
        returnPanel.addMouseListener(menu.new PopupListener());
        
        return returnPanel;
        
	}
	
	/**
	 * Erstellt das Angriffspanel
	 * @return Angriffspanel
	 */
	private static JPanel erstelleAngriffsPanel() {

		JPanel returnPanel = new JPanel(new GridBagLayout());
		returnPanel.setOpaque(false);
		
		//Komponenten werden erstellt
		JSpinner aAnzahl = new JSpinner(new SpinnerNumberModel());
		JTextField aUrsprung = new JTextField("");
		JTextField aZiel = new JTextField("");
		JButton aStarten = new JButton("Angriff starten");
		JButton aAbbruch = new JButton("Abbrechen");
		
		//Komponenten werden zu den Hashtables hinzugefgt
		anzahl.put("Angriff",aAnzahl);
		ursprung.put("Angriff", aUrsprung);
		ziel.put("Angriff", aZiel);
		starten.put("Angriff", aStarten);
		starten.put("aAbbruch", aAbbruch);

		//Komponenten werden formatiert
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.gridwidth = 2;
		constraints.ipady = 20;
		constraints.insets = new Insets(0,0,10,0);
		
        JLabel angriffpanel = new JLabel("=:.Angriff.:=");
        angriffpanel.setFont(batman.deriveFont(Font.PLAIN, 18));
        angriffpanel.setForeground(Color.WHITE);
        returnPanel.add(angriffpanel, constraints);

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.insets = new Insets(0,0,0,2);
		
        JLabel anzahlEinheitenLabel = new JLabel("Anzahl Einheiten: ");
        anzahlEinheitenLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        anzahlEinheitenLabel.setForeground(Color.WHITE);
        returnPanel.add(anzahlEinheitenLabel, constraints);

        aAnzahl.setFont(new Font("Verdana", Font.BOLD, 12));
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0,0,5,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(aAnzahl, constraints);

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 2;
		constraints.anchor = GridBagConstraints.LINE_START;
		
        JLabel angriffAusLabel = new JLabel("Angriff aus: ");
        angriffAusLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        angriffAusLabel.setForeground(Color.WHITE);
        returnPanel.add(angriffAusLabel, constraints);

		aUrsprung.setFont(new Font("Verdana", Font.BOLD, 12));
        aUrsprung.setHorizontalAlignment(JTextField.RIGHT);
		aUrsprung.setEditable(false);
		aUrsprung.setColumns(20);
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 2;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0,0,5,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(aUrsprung, constraints);

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.anchor = GridBagConstraints.LINE_START;
		
        JLabel angriffNachLabel = new JLabel("Angriff nach: ");
        angriffNachLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        angriffNachLabel.setForeground(Color.WHITE);
        returnPanel.add(angriffNachLabel, constraints);

        aZiel.setFont(new Font("Verdana", Font.BOLD, 12));
        aZiel.setHorizontalAlignment(JTextField.RIGHT);
        aZiel.setEditable(false);
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 3;
		constraints.anchor = GridBagConstraints.LINE_START;
		constraints.insets = new Insets(0,0,5,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(aZiel, constraints);

		aAbbruch.setFont(batman.deriveFont(Font.PLAIN, 14));
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 4;
		constraints.insets = new Insets(20,0,0,10);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(aAbbruch, constraints);
		
		aStarten.setFont(batman.deriveFont(Font.PLAIN, 14));
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 4;
		constraints.insets = new Insets(20,0,0,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(aStarten, constraints);

		return returnPanel; 
		
	}
	
	/**
	 * Transfer-Panel wird erstellt
	 * @return Transfer-Panel
	 */
	private static JPanel erstelleTransferPanel() {
		
		JPanel returnPanel = new JPanel(new GridBagLayout());
		returnPanel.setOpaque(false);
		
		//Komponenten werden erstellt
		JSpinner tAnzahl = new JSpinner(new SpinnerNumberModel());
		JTextField tUrsprung = new JTextField("Verschieben aus");
		JTextField tZiel = new JTextField("Verschieben nach");
		JButton tStarten = new JButton("Transfer starten");
		JButton tAbbruch = new JButton("Abbrechen");
        
		//Komponenten werden zu Hashtables hinzugefgt
        anzahl.put("Transfer",tAnzahl);
        ursprung.put("Transfer",tUrsprung);
        ziel.put("Transfer",tZiel);
        starten.put("Transfer",tStarten);
        starten.put("tAbbruch", tAbbruch);
        
        //Komponenten werden formatiert
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.ipady = 20;
		constraints.insets = new Insets(0,0,10,0);
        
        JLabel transferpanel = new JLabel("=:.Transfer.:=");
        transferpanel.setFont(batman.deriveFont(Font.PLAIN, 18));
        transferpanel.setForeground(Color.WHITE);
        returnPanel.add(transferpanel, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;

        JLabel anzahlEinheitenLabel = new JLabel("Anzahl Einheiten: ");
        anzahlEinheitenLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        anzahlEinheitenLabel.setForeground(Color.WHITE);
        returnPanel.add(anzahlEinheitenLabel, constraints);
        
        tAnzahl.setFont(new Font("Verdana", Font.BOLD, 12));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(tAnzahl, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        
        JLabel verschiebenAusLabel = new JLabel("Verschieben aus: ");
        verschiebenAusLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        verschiebenAusLabel.setForeground(Color.WHITE);
        returnPanel.add(verschiebenAusLabel, constraints);
        
        tUrsprung.setFont(new Font("Verdana", Font.BOLD, 12));
        tUrsprung.setHorizontalAlignment(JTextField.RIGHT);
        tUrsprung.setEditable(false);
        tUrsprung.setColumns(20);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(tUrsprung, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,0,2);
        
        JLabel verschiebenNachLabel = new JLabel("Verschieben nach: ");
        verschiebenNachLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        verschiebenNachLabel.setForeground(Color.WHITE);
        returnPanel.add(verschiebenNachLabel, constraints);
        
        tZiel.setFont(new Font("Verdana", Font.BOLD, 12));
        tZiel.setHorizontalAlignment(JTextField.RIGHT);
        tZiel.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(tZiel, constraints);
        
        tAbbruch.setFont(batman.deriveFont(Font.PLAIN, 14));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(20,0,0,10);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(tAbbruch, constraints);
        
        tStarten.setFont(batman.deriveFont(Font.PLAIN, 14));
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 4;
		constraints.insets = new Insets(20,0,0,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		returnPanel.add(tStarten, constraints);
        
        return returnPanel;
        
	}
	
	/**
	 * Verteidigungspanel wird erstellt
	 * @return VerteidigungsPanel
	 */
	private static JPanel erstelleVerteidigungsPanel() {
		
        JPanel returnPanel = new JPanel(new GridBagLayout());
        returnPanel.setOpaque(false);
        
        //Komponenten werden erstellt
        JTextField anzAngreifer = new JTextField();
        JSpinner vAnzahl = new JSpinner(new SpinnerNumberModel());
        JTextField vUrsprung = new JTextField("Angriff aus");
        JTextField vZiel = new JTextField("Angriff nach");
        JButton vStarten = new JButton("Verteidigung starten");
        
        //Komponenten werden zu den Hashtables hinzugefgt
        ursprung.put("Angreifer",anzAngreifer);
        anzahl.put("Verteidigung", vAnzahl);
        ursprung.put("Verteidigung", vUrsprung);
        ziel.put("Verteidigung", vZiel);
        starten.put("Verteidigung", vStarten);

        //Komponenten werden formatiert
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.ipady = 20;
        constraints.insets = new Insets(0,0,6,0);
        
        JLabel verteidigungspanel = new JLabel("=:.Verteidigung.:=");
        verteidigungspanel.setFont(batman.deriveFont(Font.PLAIN, 18));
        verteidigungspanel.setForeground(Color.WHITE);
        returnPanel.add(verteidigungspanel, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = GridBagConstraints.LINE_START;

        JLabel anzahlAngreifferLabel = new JLabel("Anzahl Angreifer: ");
        anzahlAngreifferLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        anzahlAngreifferLabel.setForeground(Color.WHITE);
        returnPanel.add(anzahlAngreifferLabel, constraints);
        
        anzAngreifer.setFont(new Font("Verdana", Font.BOLD, 12));
        anzAngreifer.setHorizontalAlignment(JTextField.RIGHT);
        anzAngreifer.setEditable(false);
        anzAngreifer.setColumns(20);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(anzAngreifer, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        
        JLabel angriffAusLabel = new JLabel("Angriff aus: ");
        angriffAusLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        angriffAusLabel.setForeground(Color.WHITE);
        returnPanel.add(angriffAusLabel, constraints);

        vUrsprung.setFont(new Font("Verdana", Font.BOLD, 12));
        vUrsprung.setHorizontalAlignment(JTextField.RIGHT);
        vUrsprung.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vUrsprung, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,0,2);
        
        JLabel angriffNachLabel = new JLabel("Angriff nach: ");
        angriffNachLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        angriffNachLabel.setForeground(Color.WHITE);
        returnPanel.add(angriffNachLabel, constraints);
        
        vZiel.setFont(new Font("Verdana", Font.BOLD, 12));
        vZiel.setHorizontalAlignment(JTextField.RIGHT);
        vZiel.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vZiel, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,0,2);
        
        JLabel anzahlVerteidigerLabel = new JLabel("Anzahl Verteidiger: ");
        anzahlVerteidigerLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        anzahlVerteidigerLabel.setForeground(Color.WHITE);
        returnPanel.add(anzahlVerteidigerLabel, constraints);
        
        vAnzahl.setFont(new Font("Verdana", Font.BOLD, 12));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vAnzahl, constraints);
        
        vStarten.setFont(batman.deriveFont(Font.PLAIN, 14));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(0,0,0,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vStarten, constraints);
        
        return returnPanel;
        
	}
	
	/**
	 * Verstrkungspanel wird erstellt
	 * @return VerstaerkungsPanel
	 */
	private static JPanel erstelleVerstaerkungsPanel() {
		
        JPanel returnPanel = new JPanel(new GridBagLayout());
        returnPanel.setOpaque(false);
        
        //Komponenten werden erstellt
        JTextField anzVerstaerkung = new JTextField();
        JTextField vZiel = new JTextField("Einheit nach");
        JButton vStarten = new JButton("Einheit setzen");

        //Komponenten werden zu den Hashtables hinzugefgt
        ursprung.put("Verstaerkung", anzVerstaerkung);
        ziel.put("Verstaerkung", vZiel);
        starten.put("Verstaerkung", vStarten);

        //Komponenten werden formatiert
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.ipady = 20;
		constraints.insets = new Insets(0,0,10,0);
        
        JLabel verstaerkungspanel = new JLabel("=:.Verstrkung.:=");
        verstaerkungspanel.setFont(batman.deriveFont(Font.PLAIN, 18));
        verstaerkungspanel.setForeground(Color.WHITE);
        returnPanel.add(verstaerkungspanel, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = GridBagConstraints.LINE_START;
        
        JLabel uebrigeEinheitenLabel = new JLabel("brige Einheiten: ");
        uebrigeEinheitenLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        uebrigeEinheitenLabel.setForeground(Color.WHITE);
        returnPanel.add(uebrigeEinheitenLabel, constraints);
        
        anzVerstaerkung.setFont(new Font("Verdana", Font.BOLD, 12));
        anzVerstaerkung.setHorizontalAlignment(JTextField.RIGHT);
        anzVerstaerkung.setEditable(false);
        anzVerstaerkung.setColumns(20);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(anzVerstaerkung, constraints);
        
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,0,2);
        
        JLabel einheitenNachLabel = new JLabel("Einheit nach: ");
        einheitenNachLabel.setFont(new Font("Verdana", Font.BOLD, 12));
        einheitenNachLabel.setForeground(Color.WHITE);
        returnPanel.add(einheitenNachLabel, constraints);
        
        vZiel.setFont(new Font("Verdana", Font.BOLD, 12));
        vZiel.setHorizontalAlignment(JTextField.RIGHT);
        vZiel.setEditable(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.anchor = GridBagConstraints.LINE_START;
        constraints.insets = new Insets(0,0,5,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vZiel, constraints);
        
        vStarten.setFont(batman.deriveFont(Font.PLAIN, 14));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(20,0,0,0);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        returnPanel.add(vStarten, constraints);
        
        return returnPanel;
	}
	
	/**
	 * Logopanel wird erstellt
	 * @return Logopanel
	 */
	private static JPanel erstelleLogoPanel() {
		
        JPanel returnPanel = new JPanel(new GridBagLayout());
        returnPanel.setOpaque(false);
        
        Icon icon = new ImageIcon("images/risiko_logo_transparenz.png");
		JLabel label = new JLabel(icon);
        
		constraints.gridx = 0;		
		constraints.gridy = 0;		
		constraints.weightx = 1.0;
		constraints.insets = new Insets(0,0,0,0); 
		constraints.fill = GridBagConstraints.BOTH;
		returnPanel.add(label,constraints);
        
        return returnPanel;
	}
	
	/**
	 * Unterklasse mit MouseAdapter zur Anzeige des Popupmens
	 * @author dgrosche
	 * @version 2009-07-01
	 */
	class PopupListener extends MouseAdapter {
	    public void mousePressed(MouseEvent e) {
	        maybeShowPopup(e);
	    }

	    public void mouseReleased(MouseEvent e) {
	        maybeShowPopup(e);
	    }

	    private void maybeShowPopup(MouseEvent e) {
	        if (e.isPopupTrigger()) {
	            popup.show(e.getComponent(),
	                       e.getX(), e.getY());
	        }
	    }
	}

}
