package risiko.client.ui.gui;

import java.rmi.RemoteException;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import risiko.common.interfaces.Land;

/**
 * JLand ist ein Label mit einer Grafikdatei als ImageIcon und einem Land,
 * dass dieses Label darstellt. Dabei ist das Label so gro wie die gesamte Karte
 * aber an allen anderen Stellen transparent
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public class JLand extends JLabel {

	private static final long serialVersionUID = 7012667332607859005L; //Versions-ID	
	private Land land;	//Land des Labels
	private ImageIcon bild; //Bild des Labels
	
	/**
	 * Erstellt ein neues Lnderlabel
	 * @param l Land des Labels
	 * @throws RemoteException 
	 */
	protected JLand(Land l) throws RemoteException {
		super();
		land = l;
		this.setBounds(0,0,1024,559);
		aktualisiere();
	}
	
	/**
	 * Aktualisiert das Label als normales Lnderlabel in der Farbe des Besitzers
	 * @throws RemoteException 
	 */
	protected void aktualisiere() throws RemoteException {
		int farbe = land.getBesitzer().getNummer();
		bild = new ImageIcon("images/LAND_"+land.getNummer()+"_"+farbe+"_0.png");
		this.setIcon(bild);
	}
	
	/**
	 * Wechselt das Bild des Labels durch ein gehighlightetes Bild aus
	 * @throws RemoteException 
	 */
	protected void highlighte() throws RemoteException {
		int farbe = land.getBesitzer().getNummer();
		bild = new ImageIcon("images/LAND_"+land.getNummer()+"_"+farbe+"_1.png");
		this.setIcon(bild);
	}

}
