package risiko.client.ui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;

/**
 * Abstrakte Klasse zur Erstellung eines Info-Panels
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public abstract class InfoPanel {

	/**
	 * Textfelder die Ausgaben empfangen knnen als statische Komponenten
	 */
	protected static JTextArea ausgabe1, ausgabe2, ausgabe3;
	private static GridBagConstraints constraints; 

	/**
	 * Erstellt das InfoPanel
	 * @return InfoPanel
	 */
	protected static JPanel create() {

		JPanel returnPanel = new JPanel(new GridBagLayout());
		returnPanel.setOpaque(false);
		returnPanel.setPreferredSize(new Dimension(250,559));

		//berschrift "Historie" setzen
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		JLabel historielabel = new JLabel("=:.Historie.:=");
		
		Font batman;
		try {
			batman = Font.createFont(Font.PLAIN, new File("batman.ttf"));
			batman = batman.deriveFont(Font.PLAIN, 16);
		} catch (FontFormatException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		} catch (IOException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		}
		historielabel.setFont(batman);
		historielabel.setForeground(Color.WHITE);
		returnPanel.add(historielabel, constraints);

		//Ausgabe "Historie" setzen
		ausgabe1 = new JTextArea();
		ausgabe1.setEditable(false);
		ausgabe1.setLineWrap(true);
		ausgabe1.setColumns(22);
		ausgabe1.setFont(new Font("Verdana", Font.BOLD, 12));
		ausgabe1.setForeground(Color.GRAY);

		JScrollPane scrollPane1 = new JScrollPane(ausgabe1);
		scrollPane1.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		scrollPane1.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.fill = GridBagConstraints.BOTH;

		returnPanel.add(scrollPane1, constraints);

		//berschrift "Info" setzen
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 2;
		JLabel infolabel = new JLabel("=:.Info.:=");
		infolabel.setFont(batman);
		infolabel.setForeground(Color.WHITE);
		returnPanel.add(infolabel, constraints);

		//Ausgabe "Info" setzen
		ausgabe2 = new JTextArea();
		ausgabe2.setEditable(false);
		ausgabe2.setLineWrap(true);
		ausgabe2.setColumns(22);
		ausgabe2.setFont(new Font("Verdana", Font.BOLD, 12));
		ausgabe2.setForeground(Color.BLUE);

		JScrollPane scrollPane2 = new JScrollPane(ausgabe2);
		scrollPane2.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		scrollPane2.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane2.setSize(new Dimension(250,150));

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.fill = GridBagConstraints.BOTH;

		returnPanel.add(scrollPane2, constraints);

		//berschrift "Fehler" setzen
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 4;
		JLabel fehlerlabel = new JLabel("=:.Fehler.:=");
		fehlerlabel.setFont(batman);
		fehlerlabel.setForeground(Color.WHITE);
		returnPanel.add(fehlerlabel, constraints);

		//Ausgabe "Fehler" setzen
		ausgabe3 = new JTextArea();
		ausgabe3.setEditable(false);
		ausgabe3.setLineWrap(true);
		ausgabe3.setColumns(22);
		ausgabe3.setFont(new Font("Verdana", Font.BOLD, 12));
		ausgabe3.setForeground(Color.RED);

		JScrollPane scrollPane3 = new JScrollPane(ausgabe3);
		scrollPane3.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		scrollPane3.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane3.setSize(new Dimension(250,150));

		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 5;
		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.fill = GridBagConstraints.BOTH;

		returnPanel.add(scrollPane3, constraints);

		return returnPanel;
	}
}
