package risiko.client.ui;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Observable;
import java.util.Observer;

import risiko.common.interfaces.Notifiable;

/**
 * Diese Klasse registriert sich beim Server als Client um nderungen zu bekommen
 * und wird vom EventMgr beobachtet um diese nderungen an das UI weiterzuleiten
 * 
 * @author dgrosche
 * @version 2009-07-05
 *
 */
public class Client extends Observable implements Notifiable {
		
		private static final long serialVersionUID = 8293138198361229358L;
		private String text;
		private static int nr;
		private String servicename;

		/**
		 * Legt einen neuen Client an, registzriert ihn am Serve
		 * und fgt den EventManager als Observer hinzu
		 * 
		 * @param o observierender EventManager
		 * @param ip IP-Adresse des Servers
		 * @throws MalformedURLException , wenn versucht wird eine inkorrekte URL zu erzeugen 
		 */
		public Client(Observer o, String ip) throws MalformedURLException {
			servicename = "rmi://"+ip+"/Client"+(nr++);
			this.addObserver(o);
	        try {
	            Notifiable stub = (Notifiable) UnicastRemoteObject.exportObject(this);
	            Naming.rebind(servicename, stub);
	        }
	        catch(RemoteException re) {
	            re.printStackTrace();
	        }
		}

		/**
		 * Bekommt ein Update vom Server
		 * @param arg Argument des Updates
		 */
		public void update(Object arg) {
			this.setChanged();
			if(arg instanceof String) {
				text = (String) arg;
				this.notifyObservers(text);
			} else if(arg==null) {
				this.notifyObservers();
			}
			
		}

		/**
		 * @return the text
		 */
		public String getText() {
			return text;
		}
		
		/**
		 * @return the servicename
		 */
		public String getServicename() {
			return servicename;
		}
}
