package risiko.server.valueobjects;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import risiko.common.interfaces.Mission;
import risiko.common.interfaces.Spieler;

/**
* mit der Spieler-Klasse kann ein Spieler-Objekt erzeugt werden, dem ein Name und eine Laenderanzahl zugewiesen wird.
* @author hhollstein
* @version 2009-06-18
*
*/
public class SpielerImpl extends UnicastRemoteObject implements Serializable, Spieler{
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 1822601210976355283L;
	private static int anzSpieler;	
	
	private boolean dran;			//Wenn das der aktive Spieler ist
	private String name;			//Name des Spieler
	private int anzLaender;			//Anzahl der Lnder
	private Vector<Integer> karten;	//Karten
	private int kartenBonus;		//Bonuseinheiten durch Einlsen von Karten
	private Mission mission;		//Mission
	private int nummer;
	
	/**
	 * @param n Name des Spielers
	 */
	public SpielerImpl(String n) throws RemoteException {
		setName(n);
		setAnzLaender(0);
		karten = new Vector<Integer>();
		kartenBonus = 0;
		
		nummer = anzSpieler;
		anzSpieler++;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#setAnzLaender(int)
	 */
	public void setAnzLaender(int anzLaender) {
		this.anzLaender = anzLaender;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getAnzLaender()
	 */
	public int getAnzLaender() {
		return anzLaender;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#addKarte(int)
	 */
	public void addKarte(int karte) {
		karten.add(karte);
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getKarten()
	 */
	public Vector<Integer> getKarten() {
		return karten;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#setKartenBonus(int)
	 */
	public void setKartenBonus(int i) {
		this.kartenBonus = i;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getKartenBonus()
	 */
	public int getKartenBonus() {
		return kartenBonus;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#setMission(risiko.server.valueobjects.MissionInt)
	 */
	public void setMission(Mission mission) {
		this.mission = mission;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getMission()
	 */
	public Mission getMission() {
		return mission;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#setDran(boolean)
	 */
	public void setDran(boolean dran) {
		this.dran = dran;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#isDran()
	 */
	public boolean isDran() {
		return dran;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#getNummer()
	 */
	public int getNummer() {
		return nummer;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#toString()
	 */
	public String toString() {
		return this.getName();
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.SpielerInt#equals(java.lang.Object)
	 */
	public boolean equals(Object vergleich) {
		if(vergleich instanceof SpielerImpl) {
			SpielerImpl vgl = (SpielerImpl) vergleich;
			if(this.getName().equals(vgl.getName()))
				return true;
		} 
		return false;
	}
	
}
