package risiko.server.valueobjects;

import java.awt.Color;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import risiko.common.interfaces.Land;
import risiko.common.interfaces.Spieler;

/**
 * mit der Land-Klasse kann ein Land-Objekt erzeugt werden, dem ein Name, die Anzahl der in ihm vorhandenen Einheiten und dessen Besitzer zugewiesen wird.
 * @author hhollstein
 * @version 2009-06-18
 *
 */
public class LandImpl extends UnicastRemoteObject implements Serializable, Land{
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -6426124995897444977L;
	private static int anzLaender;
	
	/*
	 * Name des Landes
	 * Anzahl der Einheiten (auf dem Land)
	 * Besitzer
	 * 
	 * Konstruktor:
	 * Name des Landes ber Parameter setzen
	 * Anzahl der Einheiten=0
	 * Besitzer ist leer
	 */
	private String name;
	private int anzEinheiten;
	private Spieler besitzer;
	private boolean beteiligt;
	private Color farbe;
	private int nummer;
		
	/**
	 * 
	 * @param n Name des Landes
	 * @param f Farbe auf Karte
	 */
	public LandImpl(String n, Color f) throws RemoteException {
		setName(n);
		setAnzEinheiten(1);
		setBeteiligt(false);
		setFarbe(f);
		
		nummer = anzLaender;
		anzLaender++;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#setBesitzer(risiko.server.valueobjects.Spieler)
	 */
	public void setBesitzer(Spieler besitzer) {
		this.besitzer = besitzer;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getBesitzer()
	 */
	public Spieler getBesitzer() {
		return besitzer;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#setAnzEinheiten(int)
	 */
	public void setAnzEinheiten(int anzEinheiten) {
		this.anzEinheiten = anzEinheiten;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getAnzEinheiten()
	 */
	public int getAnzEinheiten() {
		return anzEinheiten;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#setFarbe(java.awt.Color)
	 */
	public void setFarbe(Color farbe) {
		this.farbe = farbe;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getFarbe()
	 */
	public Color getFarbe() {
		return farbe;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#setBeteiligt(boolean)
	 */
	public void setBeteiligt(boolean beteiligt) {
		this.beteiligt = beteiligt;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#isBeteiligt()
	 */
	public boolean isBeteiligt() {
		return beteiligt;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getNummer()
	 */
	public int getNummer() {
		return nummer;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#toString()
	 */
	@Override
	public String toString() {
		return (this.getName()+" ("+this.getAnzEinheiten()+")");
	}
	
	public String getString() {
		return (this.getName()+" ("+this.getAnzEinheiten()+")");
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#getInfos()
	 */
	public String getInfos() throws RemoteException {
		return "Land: "+this.getName()+"\n"
			  +"Besitzer: "+this.getBesitzer().getName()+"\n"
			  +"Einheiten: "+this.getAnzEinheiten();
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LandInt#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object vergleich) {
		if(vergleich instanceof LandImpl) {
			LandImpl vgl = (LandImpl) vergleich;
			if(vgl.getName().equals(this.getName()))
				return true;
		}
		return false;
	}
}
