/**
 * 
 */
package risiko.server.valueobjects;

import java.rmi.RemoteException;
import java.util.Vector;

import risiko.common.interfaces.LaenderMission;
import risiko.common.interfaces.Land;

/**
 * Lndermission, abgeleitet von Mission
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class LaenderMissionImpl extends MissionImpl implements LaenderMission {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -6179271418499675504L;
	
	int anzLaender;
	int anzEinheiten;
	Vector<Land> laenderliste;

	/**
	 * Erstellt eine neue Lndermission
	 * 
	 * @param anzLaender Anzahl zu erobernder Lnder
	 * @param anzEinheiten Mindestanzahl der Einheiten pro Land
	 * @throws RemoteException 
	 */
	public LaenderMissionImpl(int anzLaender, int anzEinheiten) throws RemoteException {
		super();
		this.anzLaender = anzLaender;
		this.anzEinheiten = anzEinheiten;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LaenderMissionInt#setLaenderliste(java.util.Vector)
	 */
	public void setLaenderliste(Vector<Land> laenderliste) {
		this.laenderliste = laenderliste;
	}
	
	/**
	 * @return ob Lnderanzahl stimmt
	 * @throws RemoteException 
	 */
	private boolean laenderAnzahl() throws RemoteException {
		if(spieler.getAnzLaender()>=anzLaender)
			return true;
		else
			return false;
	}
	
	/**
	 * @return ob Anzahl Einheiten pro Land stimmt
	 * @throws RemoteException 
	 */
	private boolean laenderListe() throws RemoteException {
		if(laenderliste.size()>=anzLaender) {
			for(Land l : laenderliste) {
				if(l.getAnzEinheiten()<anzEinheiten) {
					return false;
				}
			}
			return true;
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.LaenderMissionInt#pruefErfuellt()
	 */
	@Override
	public void pruefErfuellt() throws RemoteException {
		if(anzEinheiten==1) {
			super.setErfuellt(laenderAnzahl());
		} else {
			super.setErfuellt(laenderListe()); 
		}
	}

}
