package risiko.server.valueobjects;

import java.rmi.RemoteException;
import java.util.Vector;

import risiko.common.interfaces.Kontinent;
import risiko.common.interfaces.KontinentMission;

/**
 * Kontinentmission, abgeleitet von Mission
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class KontinentMissionImpl extends MissionImpl implements KontinentMission {

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 4130576963029507815L;
	
	Vector<Kontinent> befreiendeKontinente;
	Vector<Kontinent> kontinentenliste;
	int anzahlKontinente;
	
	/**
	 * Erstellt eine neue Kontinentmission
	 * 
	 * @param anzKont Anzahl zu erobernder Kontinente
	 */
	public KontinentMissionImpl(int anzKont) throws RemoteException {
		super();
		befreiendeKontinente = new Vector<Kontinent>();
		anzahlKontinente = anzKont;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentMissionInt#addKontinent(risiko.server.valueobjects.Kontinent)
	 */
	public void addKontinent(Kontinent k) {
		befreiendeKontinente.add(k);
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentMissionInt#setKontinentenliste(java.util.Vector)
	 */
	public void setKontinentenliste(Vector<Kontinent> kliste) {
		kontinentenliste = new Vector<Kontinent>(kliste);
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentMissionInt#pruefErfuellt()
	 */
	@Override
	public void pruefErfuellt() throws RemoteException {
		boolean erg = true;
		//Wenn ein Kontinent aus der Liste zu befreiender Kontinenten nicht erobert ist
		for(Kontinent k : befreiendeKontinente) {
			if(k.isErobert()) {
				//Wenn eroberter Kontinent nicht dem Spieler gehrt
				if(!k.getLaenderListe().get(0).getBesitzer().equals(spieler)) {
					//setze erg auf false
					erg = false;
				}
			} else {
				//setze erg auf false
				erg = false;
			}
		}
		//Wenn die Anzahl mit der Gre der Liste bereinstimmt
		if(anzahlKontinente==befreiendeKontinente.size()) {
			//nimm Ergebnis von oben
			super.setErfuellt(erg);
		} else {
			//fhre erweiterte Prfung aus
			if(erg) super.setErfuellt(extendedPruef());
			else	super.setErfuellt(false);
		}
	}
	
	/**
	 * Erweiterte Prfung der Kontinenten
	 * 
	 * @return Erfolgswert der Prfung
	 * @throws RemoteException 
	 */
	private boolean extendedPruef() throws RemoteException {
		//bereits eroberte Kontinente werden rausgeschmissen
		for(Kontinent k : befreiendeKontinente) {
			kontinentenliste.removeElement(k);
		}
		//brigen Kontinente werden nach Besitzer berprft
		for(Kontinent k : kontinentenliste) {
			if(k.isErobert()) {
				if(k.getLaenderListe().firstElement().getBesitzer().equals(spieler)) {
					return true;
				}
			}
		}
		return false;
	}

}
