package risiko.server.valueobjects;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import risiko.common.interfaces.Kontinent;
import risiko.common.interfaces.Land;
	
/**
 * mit der Kontinent-Klasse kann ein Kontinent-Objekt erzeugt werden, dem ein Name, eine Punktewert und Laender zugewiesen wird.
 *  
 * @author hhollstein
 * @version 2009-05-25
 *
 */
public class KontinentImpl extends UnicastRemoteObject implements Serializable, Kontinent {
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 3307931640058856352L;
	
	/*
	 * Name des Kontinents
	 * Lnder des Kontinents
	 * Punkte (fr den Besitzer des Kontinents)
	 * Ist der Kontinent erobert
	 * 
	 * Konstruktor:
	 * Name des Kontinents ber Parameter
	 * Punkte des Kontinents ber Parameter
	 * Lnderliste ber Parameter
	 */
	
	private String name;
	private int punkt;
	private Vector<Land> laenderListe;
	private boolean erobert;
	
	/**
	 * @param n Name des Kontinenten
	 * @param p Punktzahl
	 */
	public KontinentImpl(String n, int p) throws RemoteException {
		setName(n);
		setPunkt(p);
		setLaenderListe(new Vector<Land>());
		setErobert(false);
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#setPunkt(int)
	 */
	public void setPunkt(int punkt) {
		this.punkt = punkt;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#getPunkt()
	 */
	public int getPunkt() {
		return punkt;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#setLaenderListe(java.util.Vector)
	 */
	public void setLaenderListe(Vector<Land> laenderListe) {
		this.laenderListe = laenderListe;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#getLaenderListe()
	 */
	public Vector<Land> getLaenderListe() {
		return laenderListe;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#setErobert(boolean)
	 */
	public void setErobert(boolean erobert) {
		this.erobert = erobert;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#isErobert()
	 */
	public boolean isErobert() {
		return erobert;
	}

	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#toString()
	 */
	public String toString() {
		return this.getName() +" ("+this.getPunkt()+")" ;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.KontinentInt#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object vergleich) {
		if(vergleich instanceof KontinentImpl) {
			KontinentImpl vgl = (KontinentImpl) vergleich;
			if(this.getName().equals(vgl.getName()) && this.getPunkt()==vgl.getPunkt())
				return true;
		}
		return false;
	}
	
	
}
