package risiko.server.valueobjects;

import java.rmi.RemoteException;
import java.util.Vector;

import risiko.common.interfaces.BefreiungsMission;
import risiko.common.interfaces.Spieler;

/**
 * Befreiungsmissionen, von Missionen abgeleitet
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class BefreiungsMissionImpl extends MissionImpl implements BefreiungsMission {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 7305852569500070006L;
	
	private Vector<Spieler> spielerliste;
	private Spieler feind;
	
	/**
	 * Erstellt eine neue Befreiungsmission
	 * 
	 * @param p Spieler, der besiegt werden soll
	 */
	public BefreiungsMissionImpl(Spieler p) throws RemoteException {
		feind = p;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.BefreiungsMissionInt#setSpielerliste(java.util.Vector)
	 */
	public void setSpielerliste(Vector<Spieler> spielerliste)  {
		this.spielerliste = spielerliste;
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.BefreiungsMissionInt#pruefErfuellt()
	 */
	@Override
	public void pruefErfuellt() {
		if(!spielerliste.contains(feind)) {
			super.setErfuellt(true);
		} else {
			super.setErfuellt(false);
		}
	}
	
	/* (non-Javadoc)
	 * @see risiko.server.valueobjects.BefreiungsMissionInt#getFeind()
	 */
	public Spieler getFeind() {
		return feind;
	}

}
