package risiko.server.net;

import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

import risiko.common.interfaces.SpielMgr;
import risiko.server.domain.SpielMgrImpl;

public abstract class RisikoServer {
	
	public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
        	LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
            String name = "RisikoService";
            SpielMgr engine = new SpielMgrImpl();
            SpielMgr stub =
                (SpielMgr) UnicastRemoteObject.exportObject(engine, 0);
            Registry registry = LocateRegistry.getRegistry();
            registry.rebind(name, stub);
            System.out.println("Risiko Engine bound");
        } catch (Exception e) {
            System.err.println("Risiko Engine exception:");
            e.printStackTrace();
        }
	}

}
