package risiko.server.domain;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

import risiko.common.exceptions.LandNichtImBesitzException;
import risiko.common.interfaces.Land;
import risiko.common.interfaces.Spieler;
import risiko.server.valueobjects.SpielerImpl;

/**
 * Verwaltet Spieler und Logik des Spielers, d.h. hier werden die Aktionen
 * des Spielers ausgefhrt.
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class SpielerMgr implements Serializable {

	private static final long serialVersionUID = -7341580337650926196L;
	private Spieler aktiverSpieler;								//Aktiver Spieler
	private Vector<Spieler> spieler  = new Vector<Spieler>();	//Alle Spieler
		
	/**
	 * Fgt einen Spieler hinzu.
	 * 
	 * @param spielername Name des Spielers
	 * @throws RemoteException 
	 */
	public void addSpieler(String spielername) throws RemoteException {
		spieler.add(new SpielerImpl(spielername));
	}
	
	/**
	 * Setzt beim aktiven Spieler, dran auf false 
	 * und beim nchsten Spieler in der Reihe dran auf true,
	 * sowie diesen als aktiverSpieler
	 * @throws RemoteException 
	 */
	public void beendeZug() throws RemoteException {
		pruefSpieler();
		int index = spieler.indexOf(this.getAktiverSpieler());
		if(!(spieler.elementAt(index).equals(spieler.lastElement()))) {
			spieler.elementAt(index).setDran(false);
			spieler.elementAt(index+1).setDran(true);
		} else {
			spieler.elementAt(index).setDran(false);
			spieler.firstElement().setDran(true);
		}
		this.setAktiverSpieler();
	}
	
	/**
	 * 
	 * @return Spieler, der dran ist.
	 * @throws RemoteException 
	 */
	public Spieler getAktiverSpieler() throws RemoteException {
		this.setAktiverSpieler();
		return this.aktiverSpieler;
	}
	
	/**
	 * @return Vektor mit allen Spielern
	 */
	public Vector<Spieler> getAllSpieler() {
		return this.spieler;
	}
	
	/**
	 * Prft ob noch alle Spieler Lnder besitzen und kickt diese sonst raus
	 * @throws RemoteException 
	 */
	private void pruefSpieler() throws RemoteException {
		Vector<Spieler> loeschliste = new Vector<Spieler>();
		for(Spieler p : spieler) {
			if(p.getAnzLaender()==0) {
				loeschliste.add(p);
			}
		}
		for (Spieler p : loeschliste) {
			spieler.removeElement(p);
		}
	}
	
	/**
	 * Setzt den ersten Spieler mit der Eigenschaft dran, als aktiven Spieler ein.
	 * @throws RemoteException 
	 */
	private void setAktiverSpieler() throws RemoteException {
		Iterator<Spieler> iter = spieler.iterator();
		while(iter.hasNext()) {
			Spieler einSpieler = iter.next();
			if(einSpieler.isDran()) {
				this.aktiverSpieler = einSpieler;
			}
		}
	}
	
	/**
	 * Es werden anzEinheiten ins Land a gesetzt
	 * 
	 * @param a Zielland 
	 * @param anzEinheiten Anzahl der zustzlichen Einheiten
	 * @throws LandNichtImBesitzException , wenn A nicht im Besitz des aktiven Spielers.
	 * @throws RemoteException 
	 */
	public void setzeEinheiten(Land a, int anzEinheiten) throws LandNichtImBesitzException, RemoteException {

		if(a.getBesitzer().getNummer()!=this.aktiverSpieler.getNummer()) {
			throw new LandNichtImBesitzException(a, aktiverSpieler);
		} else {
			a.setAnzEinheiten(a.getAnzEinheiten()+anzEinheiten);
		}
		
	}
	

}
