package risiko.server.domain;

import java.rmi.RemoteException;
import java.util.Vector;

import risiko.common.interfaces.LaenderMission;
import risiko.common.interfaces.Land;
import risiko.common.interfaces.Mission;
import risiko.common.interfaces.Spieler;
import risiko.server.valueobjects.BefreiungsMissionImpl;
import risiko.server.valueobjects.KontinentMissionImpl;
import risiko.server.valueobjects.LaenderMissionImpl;
import risiko.server.valueobjects.MissionImpl;

/**
 * Verwaltet alle Missionen
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class MissionsMgr {
	
	private Vector<MissionImpl> missionsliste;
	private WeltMgr welt;
	
	/**
	 * Erstellt alle Missionen
	 * 
	 * @param welt vorhandene Welt
	 * @param spielerliste alle Spieler
	 * @throws RemoteException 
	 */
	public MissionsMgr(WeltMgr welt, Vector<Spieler> spielerliste) throws RemoteException {
		this.welt = welt;
		missionsliste = new Vector<MissionImpl>();
		createKontinentMissionen();
		createLaenderMissionen();
		createBefreiungsMissionen(spielerliste);
	}
	
	/**
	 * Befreiungsmissionen werden fr jeden Spieler erstellt
	 * 
	 * @param spielerliste alle aktiven Spieler
	 * @throws RemoteException 
	 */
	private void createBefreiungsMissionen(Vector<Spieler> spielerliste) throws RemoteException {
		BefreiungsMissionImpl m;
		for(Spieler p : spielerliste) {
			m = new BefreiungsMissionImpl(p);
			m.setSpielerliste(spielerliste);
			m.setMessage("Befreien Sie alle Lnder des Spielers "+p);
			missionsliste.add(m);
		}
	}
	
	/**
	 * Kontinentenmissionen werden erstellt
	 * @throws RemoteException 
	 */
	private void createKontinentMissionen() throws RemoteException {
		KontinentMissionImpl m = new KontinentMissionImpl(2); 
		m.setMessage("Befreien Sie Nordamerika und Afrika!");
		m.addKontinent(welt.getKontinentenliste().elementAt(0));
		m.addKontinent(welt.getKontinentenliste().elementAt(3));
		missionsliste.add(m);
		
		m = new KontinentMissionImpl(2); 
		m.setMessage("Befreien Sie Nordamerika und Australien!");
		m.addKontinent(welt.getKontinentenliste().elementAt(0));
		m.addKontinent(welt.getKontinentenliste().elementAt(5));
		missionsliste.add(m);
		
		m = new KontinentMissionImpl(2); 
		m.setMessage("Befreien Sie Asien und Sdamerika!");
		m.addKontinent(welt.getKontinentenliste().elementAt(1));
		m.addKontinent(welt.getKontinentenliste().elementAt(4));
		missionsliste.add(m);
		
		m = new KontinentMissionImpl(2); 
		m.setMessage("Befreien Sie Afrika und Asien!");
		m.addKontinent(welt.getKontinentenliste().elementAt(3));
		m.addKontinent(welt.getKontinentenliste().elementAt(4));
		missionsliste.add(m);
		
		m = new KontinentMissionImpl(3); 
		m.setMessage("Befreien Sie Europa, Sdamerika und einen weiteren Kontinenten!");
		m.addKontinent(welt.getKontinentenliste().elementAt(1));
		m.addKontinent(welt.getKontinentenliste().elementAt(2));
		m.setKontinentenliste(welt.getKontinentenliste());
		missionsliste.add(m);
		
		m = new KontinentMissionImpl(3); 
		m.setMessage("Befreien Sie Europa, Australien und einen weiteren Kontinenten!");
		m.addKontinent(welt.getKontinentenliste().elementAt(2));
		m.addKontinent(welt.getKontinentenliste().elementAt(5));
		m.setKontinentenliste(welt.getKontinentenliste());
		missionsliste.add(m);
	}
	
	/**
	 * Lndermissionen werden erstellt
	 * @throws RemoteException 
	 */
	private void createLaenderMissionen() throws RemoteException {
		LaenderMissionImpl m = new LaenderMissionImpl(24,1);
		m.setMessage("Befreien Sie 24 Lnder Ihrer Wahl!");
		missionsliste.add(m);
		
		m = new LaenderMissionImpl(18,2);
		m.setMessage("Befreien Sie 18 Lnder und setzen Sie in jedes Land min. 2 Armeen!");
		m.setLaenderliste(welt.getLaenderliste());
		missionsliste.add(m);
	}
	
	/**
	 * @return the missionsliste
	 */
	public Vector<MissionImpl> getMissionsliste() {
		return missionsliste;
	}
	
	/**
	 * Prft alle Missionen
	 * @throws RemoteException 
	 */
	public void pruefMissionen() throws RemoteException {
		welt.pruefKontinente();
		for(Mission m : missionsliste) {
			m.pruefErfuellt();
		}
	}
	
	/**
	 * Setzt zur Lndermission m eine Lnderliste
	 * 
	 * @param m Lndermission, die berprft werden soll
	 * @param laenderliste Lnderliste die berprft werden soll
	 * @throws RemoteException 
	 */
	public void setLaenderliste(Mission m, Vector<Land> laenderliste) throws RemoteException {
		if(m instanceof LaenderMissionImpl) {
			((LaenderMission) m).setLaenderliste(laenderliste);
		}
	}

}
