package risiko.common.interfaces;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;

/**
 * Interface zum Valueobject
 * 
 * @author dgrosche
 * @version 2009-07-01
 *
 */
public interface Spieler extends Remote, Serializable {

	/**
	 * @param name the name to set
	 */
	public abstract void setName(String name) throws RemoteException;

	/**
	 * @return the name
	 */
	public abstract String getName() throws RemoteException;

	/**
	 * @param anzLaender the anzLaender to set
	 */
	public abstract void setAnzLaender(int anzLaender) throws RemoteException;

	/**
	 * @return the anzLaender
	 */
	public abstract int getAnzLaender() throws RemoteException;

	/**
	 * @param karte the karte to add
	 */
	public abstract void addKarte(int karte) throws RemoteException;

	/**
	 * @return the karten
	 */
	public abstract Vector<Integer> getKarten() throws RemoteException;

	/**
	 * @param i the kartenBonus to set
	 */
	public abstract void setKartenBonus(int i) throws RemoteException;

	/**
	 * @return the kartenBonus
	 */
	public abstract int getKartenBonus() throws RemoteException;

	/**
	 * @param mission the mission to set
	 */
	public abstract void setMission(Mission mission) throws RemoteException;

	/**
	 * @return the mission
	 */
	public abstract Mission getMission() throws RemoteException;

	/**
	 * @param dran the dran to set
	 */
	public abstract void setDran(boolean dran) throws RemoteException;

	/**
	 * @return the dran
	 */
	public abstract boolean isDran() throws RemoteException;

	/**
	 * @return the nummer
	 */
	public abstract int getNummer() throws RemoteException;

}