package risiko.common.exceptions;

/**
 * Der Verteidiger versucht mit mehr Einheiten zu verteidigen, als angegriffen wird
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class VerteidigerUebersteigtAngreiferException extends Exception {

	/**
	 * Konstruktor
	 * 
	 * @param x Anzahl der Angreifer
	 * @param y Anzahl der Verteidiger
	 */
	public VerteidigerUebersteigtAngreiferException(int x, int y) {
		super("FEHLER: Sie knnen nicht mit "+y+" Einheiten verteidigen, wenn nur mit "+x+" Einheiten angegriffen wird.");
	}

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 4017625769225178277L;

}
