package risiko.common.exceptions;

import java.rmi.RemoteException;

import risiko.common.interfaces.Land;

/**
 * Fehler, wenn ein Land nicht die gesuchten Nachbarn hat
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class KeineNachbarnException extends Exception {

	/**
	 * Konstruktor
	 * 
	 * @param a Land, das keine Nachbarn hat
	 * @param i fremde oder eigene Nachbarn?
	 * @throws RemoteException 
	 */
	public KeineNachbarnException(Land a, boolean i) throws RemoteException {
		super("Fr "+a.getName()+" gibt es keine "+((i)?"fremden":"eigenen")+" Nachbarn!");
	}

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 1337133750717253091L;

}
