package risiko.local.valueobjects;

import java.io.Serializable;
import java.util.Vector;

/**
* mit der Spieler-Klasse kann ein Spieler-Objekt erzeugt werden, dem ein Name und eine Laenderanzahl zugewiesen wird.
* @author hhollstein
* @version 2009-06-18
*
*/
public class Spieler implements Serializable{
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 1822601210976355283L;
	private static int anzSpieler;	
	
	private boolean dran;			//Wenn das der aktive Spieler ist
	private String name;			//Name des Spieler
	private int anzLaender;			//Anzahl der Lnder
	private Vector<Integer> karten;	//Karten
	private int kartenBonus;		//Bonuseinheiten durch Einlsen von Karten
	private Mission mission;		//Mission
	private int nummer;
	
	/**
	 * @param n Name des Spielers
	 */
	public Spieler(String n){
		setName(n);
		setAnzLaender(0);
		karten = new Vector<Integer>();
		kartenBonus = 0;
		
		nummer = anzSpieler;
		anzSpieler++;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param anzLaender the anzLaender to set
	 */
	public void setAnzLaender(int anzLaender) {
		this.anzLaender = anzLaender;
	}

	/**
	 * @return the anzLaender
	 */
	public int getAnzLaender() {
		return anzLaender;
	}

	/**
	 * @param karte the karte to add
	 */
	public void addKarte(int karte) {
		karten.add(karte);
	}

	/**
	 * @return the karten
	 */
	public Vector<Integer> getKarten() {
		return karten;
	}
	
	/**
	 * @param i the kartenBonus to set
	 */
	public void setKartenBonus(int i) {
		this.kartenBonus = i;
	}
	
	/**
	 * @return the kartenBonus
	 */
	public int getKartenBonus() {
		return kartenBonus;
	}

	/**
	 * @param mission the mission to set
	 */
	public void setMission(Mission mission) {
		this.mission = mission;
	}

	/**
	 * @return the mission
	 */
	public Mission getMission() {
		return mission;
	}

	/**
	 * @param dran the dran to set
	 */
	public void setDran(boolean dran) {
		this.dran = dran;
	}

	/**
	 * @return the dran
	 */
	public boolean isDran() {
		return dran;
	}
	
	/**
	 * @return the nummer
	 */
	public int getNummer() {
		return nummer;
	}
	
	/**
	 * Gibt Namen des Spielers zurck
	 */
	public String toString() {
		return this.getName();
	}
	
	/**
	 * 
	 * @param vgl Vergleichsspieler
	 * @return true, wenn Name gleich; false, wenn Name verschieden.
	 */
	public boolean equals(Spieler vgl) {
		if(this.getName().equals(vgl.getName()))
			return true;
		else
			return false;
	}
	
}
