package risiko.local.valueobjects;

import java.io.Serializable;

/**
 * Abstrakte Missionsklasse
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public abstract class Mission implements Serializable {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -5767809863926615731L;
	
	protected Spieler spieler;
	private boolean erfuellt;
	private String message;
	
	/**
	 * Eine neue Mission wird erstellt mit einem leeren Spieler
	 */
	public Mission() {
		spieler = new Spieler("");
	}
	
	/**
	 * Prft ob Mission erfllt wurde
	 */
	public abstract void pruefErfuellt();
	
	/**
	 * @param p the spieler to set
	 */
	public void setSpieler(Spieler p) {
		spieler = p;
	}

	/**
	 * @param erfuellt the erfuellt to set
	 */
	protected void setErfuellt(boolean erfuellt) {
		this.erfuellt = erfuellt;
	}
	
	/**
	 * @return the erfuellt
	 */
	public boolean isErfuellt() {
		return erfuellt;
	}
	
	/**
	 * @param s the message to set
	 */
	public void setMessage(String s) {
		message = s;
	}
	
	/**
	 * Gibt Message zurck
	 */
	public String toString() {
		return message;
	}

	/*
	 * TYP 1: Kontinente befreien
	 * 
	 * Befreien Sie Nordamerika und Afrika!
	 * Befreien Sie Nordamerika und Australien!
	 * Befreien Sie Asien und Sdamerika!
	 * Befreien Sie Afrika und Asien!
	 * 
	 * Befreien Sie Europa, Sdamerika und einen dritten
	 *  	Kontinent Ihrer Wahl!
	 * Befreien Sie Europa, Australien und einen dritten
	 *		Kontinent Ihrer Wahl!
	 *
	 * TYP 2: Lnder befreien
	 * 
	 * Befreien Sie 24 Lnder Ihrer Wahl!
	 * 
	 * Befreien Sie 18 Lnder und setzen Sie in jedes Land
	 * 		mindestens 2 Armeen!
	 *
	 * TYP 3: Feinde vernichten
	 * 
	 * Befreien Sie alle Lnder von den roten Armeen!
	 *		Wenn Sie selbst diese Armeen besitzen, heit Ihr Ziel:
	 *		Befreien Sie 24 Lnder Ihrer Wahl!
	 */
}
