package risiko.local.valueobjects;

import java.awt.Color;
import java.io.Serializable;

/**
 * mit der Land-Klasse kann ein Land-Objekt erzeugt werden, dem ein Name, die Anzahl der in ihm vorhandenen Einheiten und dessen Besitzer zugewiesen wird.
 * @author hhollstein
 * @version 2009-06-18
 *
 */
public class Land implements Serializable{
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -6426124995897444977L;
	private static int anzLaender;
	
	/*
	 * Name des Landes
	 * Anzahl der Einheiten (auf dem Land)
	 * Besitzer
	 * 
	 * Konstruktor:
	 * Name des Landes ber Parameter setzen
	 * Anzahl der Einheiten=0
	 * Besitzer ist leer
	 */
	private String name;
	private int anzEinheiten;
	private Spieler besitzer;
	private boolean beteiligt;
	private Color farbe;
	private int nummer;
		
	/**
	 * 
	 * @param n Name des Landes
	 * @param f Farbe auf Karte
	 */
	public Land(String n, Color f) {
		setName(n);
		setAnzEinheiten(1);
		setBeteiligt(false);
		setFarbe(f);
		
		nummer = anzLaender;
		anzLaender++;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param besitzer the besitzer to set
	 */
	public void setBesitzer(Spieler besitzer) {
		this.besitzer = besitzer;
	}

	/**
	 * @return the besitzer
	 */
	public Spieler getBesitzer() {
		return besitzer;
	}

	/**
	 * @param anzEinheiten the anzEinheiten to set
	 */
	public void setAnzEinheiten(int anzEinheiten) {
		this.anzEinheiten = anzEinheiten;
	}

	/**
	 * @return the anzEinheiten
	 */
	public int getAnzEinheiten() {
		return anzEinheiten;
	}
	
	/**
	 * @param farbe the farbe to set
	 */
	public void setFarbe(Color farbe) {
		this.farbe = farbe;
	}

	/**
	 * @return the farbe
	 */
	public Color getFarbe() {
		return farbe;
	}

	/**
	 * @param beteiligt the beteiligt to set
	 */
	public void setBeteiligt(boolean beteiligt) {
		this.beteiligt = beteiligt;
	}

	/**
	 * @return the beteiligt
	 */
	public boolean isBeteiligt() {
		return beteiligt;
	}
	
	/**
	 * @return the nummer
	 */
	public int getNummer() {
		return nummer;
	}

	/**
	 * Gibt Namen des Landes zurck
	 */
	@Override
	public String toString() {
		return (this.getName()+" ("+this.getAnzEinheiten()+")");
	}
	
	/**
	 * @return Alle Informationen des Landes (3zeilig)
	 */
	public String getInfos() {
		return "Land: "+this.getName()+"\n"
			  +"Besitzer: "+this.getBesitzer()+"\n"
			  +"Einheiten: "+this.getAnzEinheiten();
	}
	
	/**
	 * 
	 * @param vgl Vergleichsland
	 * @return true, wenn Name gleich; false, wenn Name verschieden.
	 */
	public boolean equals(Land vgl) {
		if(vgl.getName().equals(this.getName()))
			return true;
		else
			return false;
	}
}
