/**
 * 
 */
package risiko.local.valueobjects;

import java.util.Vector;

/**
 * Lndermission, abgeleitet von Mission
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class LaenderMission extends Mission {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -6179271418499675504L;
	
	private int anzLaender;
	private int anzEinheiten;
	private Vector<Land> laenderliste;

	/**
	 * Erstellt eine neue Lndermission
	 * 
	 * @param anzLaender Anzahl zu erobernder Lnder
	 * @param anzEinheiten Mindestanzahl der Einheiten pro Land
	 */
	public LaenderMission(int anzLaender, int anzEinheiten) {
		super();
		this.anzLaender = anzLaender;
		this.anzEinheiten = anzEinheiten;
	}
	
	/**
	 * @param laenderliste the laenderliste to set
	 */
	public void setLaenderliste(Vector<Land> laenderliste) {
		this.laenderliste = laenderliste;
	}
	
	/**
	 * @return ob Lnderanzahl stimmt
	 */
	private boolean laenderAnzahl() {
		if(spieler.getAnzLaender()>=anzLaender)
			return true;
		else
			return false;
	}
	
	/**
	 * @return ob Anzahl Einheiten pro Land stimmt
	 */
	private boolean laenderListe() {
		if(laenderliste.size()>=anzLaender) {
			for(Land l : laenderliste) {
				if(l.getAnzEinheiten()<anzEinheiten) {
					return false;
				}
			}
			return true;
		}
		return false;
	}
	
	@Override
	public void pruefErfuellt() {
		if(anzEinheiten==1) {
			super.setErfuellt(laenderAnzahl());
		} else {
			super.setErfuellt(laenderListe()); 
		}
	}

}
