package risiko.local.valueobjects;

import java.io.Serializable;
import java.util.Vector;
	
/**
 * mit der Kontinent-Klasse kann ein Kontinent-Objekt erzeugt werden, dem ein Name, eine Punktewert und Laender zugewiesen wird.
 *  
 * @author hhollstein
 * @version 2009-05-25
 *
 */
public class Kontinent implements Serializable {
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 3307931640058856352L;
	
	/*
	 * Name des Kontinents
	 * Lnder des Kontinents
	 * Punkte (fr den Besitzer des Kontinents)
	 * Ist der Kontinent erobert
	 * 
	 * Konstruktor:
	 * Name des Kontinents ber Parameter
	 * Punkte des Kontinents ber Parameter
	 * Lnderliste ber Parameter
	 */
	
	private String name;
	private int punkt;
	private Vector<Land> laenderListe;
	private boolean erobert;
	
	/**
	 * @param n Name des Kontinenten
	 * @param p Punktzahl
	 */
	public Kontinent(String n, int p){
		setName(n);
		setPunkt(p);
		setLaenderListe(new Vector<Land>());
		setErobert(false);
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param punkt the punkt to set
	 */
	public void setPunkt(int punkt) {
		this.punkt = punkt;
	}

	/**
	 * @return the punkt
	 */
	public int getPunkt() {
		return punkt;
	}

	/**
	 * @param laenderListe the laenderListe to set
	 */
	public void setLaenderListe(Vector<Land> laenderListe) {
		this.laenderListe = laenderListe;
	}

	/**
	 * @return the laenderListe
	 */
	public Vector<Land> getLaenderListe() {
		return laenderListe;
	}
	
	/**
	 * @param erobert the erobert to set
	 */
	public void setErobert(boolean erobert) {
		this.erobert = erobert;
	}

	/**
	 * @return the erobert
	 */
	public boolean isErobert() {
		return erobert;
	}

	/**
	 * Gibt Kontinentnamen und Punktzahl zurck
	 */
	public String toString() {
		return this.getName() +" ("+this.getPunkt()+")" ;
	}
	
	/**
	 * @param vgl Vergleichskontinent
	 * @return true, wenn Name und Pkt-Zahl gleich;
	 */
	public boolean equals(Kontinent vgl) {
		if(this.getName().equals(vgl.getName()) && this.getPunkt()==vgl.getPunkt())
			return true;
		else
			return false;
	}
	
	
}
