package risiko.local.valueobjects;

import java.util.Vector;

/**
 * Befreiungsmissionen, von Missionen abgeleitet
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class BefreiungsMission extends Mission {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 7305852569500070006L;
	
	private Vector<Spieler> spielerliste;
	private Spieler feind;
	
	/**
	 * Erstellt eine neue Befreiungsmission
	 * 
	 * @param p Spieler, der besiegt werden soll
	 */
	public BefreiungsMission(Spieler p) {
		feind = p;
	}
	
	/**
	 * @param spielerliste Liste mit mit allen Spielern
	 */
	public void setSpielerliste(Vector<Spieler> spielerliste)  {
		this.spielerliste = spielerliste;
	}
	
	@Override
	public void pruefErfuellt() {
		if(!spielerliste.contains(feind)) {
			super.setErfuellt(true);
		} else {
			super.setErfuellt(false);
		}
	}
	
	/**
	 * @return Spieler der besiegt werden soll
	 */
	public Spieler getFeind() {
		return feind;
	}

}
