package risiko.local.ui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Erstellt das Wrfelpanel
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public abstract class WuerfelPanel {

	/**
	 * Die Wrfellabel
	 */
	private static JLabel[] wuerfel;

	private static GridBagConstraints constraints;

	/**
	 * Erstellt das Wrfelpanel
	 * @return WuerfelPanel
	 */
	protected static JPanel create() {

		JPanel thisPanel = new JPanel(new GridBagLayout());
		thisPanel.setOpaque(false);

		wuerfel = new JLabel[5];

		Font batman;
		try {
			batman = Font.createFont(Font.PLAIN, new File("batman.ttf"));
			batman = batman.deriveFont(Font.PLAIN, 32);
		} catch (FontFormatException e) {
			batman = new Font("Verdana",Font.BOLD,72);
		} catch (IOException e) {
			batman = new Font("Verdana",Font.BOLD,72);
		}

		Icon icong = new ImageIcon("images/wuerfel_grau.png");
		Icon iconr = new ImageIcon("images/wuerfel_rot.png");
		wuerfel[0] = new JLabel("0", iconr, JLabel.CENTER); //erzeugt Label mit Text und Grafik zentriert angeordnet
		wuerfel[0].setHorizontalTextPosition(0);//setzt die Position des Textes
		wuerfel[0].setForeground(Color.WHITE);
		wuerfel[0].setFont(batman);
		wuerfel[0].setDisabledIcon(icong);
		constraints = new GridBagConstraints();
		constraints.gridx = 0;		// 0. Spalte
		constraints.gridy = 0;		// 0. Zeile
		constraints.gridwidth = 2;  //nimmt 2 Spalten ein
		constraints.weightx = 1.0;
		constraints.fill = GridBagConstraints.BOTH;	// Horizontal ausfllen  	
		thisPanel.add(wuerfel[0], constraints);

		wuerfel[1] = new JLabel("0", iconr, JLabel.CENTER);
		wuerfel[1].setHorizontalTextPosition(0);
		wuerfel[1].setForeground(Color.WHITE);
		wuerfel[1].setFont(batman);
		wuerfel[1].setDisabledIcon(icong);
		constraints = new GridBagConstraints();
		constraints.gridx = 2;		
		constraints.gridy = 0;		
		constraints.gridwidth = 2;
		constraints.weightx = 1.0;	
		constraints.fill = GridBagConstraints.BOTH;  	
		thisPanel.add(wuerfel[1], constraints);

		wuerfel[2] = new JLabel("0", iconr, JLabel.CENTER);
		wuerfel[2].setHorizontalTextPosition(0);
		wuerfel[2].setForeground(Color.WHITE);
		wuerfel[2].setFont(batman);
		wuerfel[2].setDisabledIcon(icong);
		constraints = new GridBagConstraints();
		constraints.gridx = 4;		
		constraints.gridy = 0;		
		constraints.gridwidth = 2;
		constraints.weightx = 1.0;	
		constraints.fill = GridBagConstraints.BOTH;
		thisPanel.add(wuerfel[2], constraints);

		Icon iconb = new ImageIcon("images/wuerfel_blau.png");
		wuerfel[3] = new JLabel("0", iconb, JLabel.CENTER);
		wuerfel[3].setHorizontalTextPosition(0);
		wuerfel[3].setForeground(Color.WHITE);
		wuerfel[3].setFont(batman);
		wuerfel[3].setDisabledIcon(icong);
		constraints = new GridBagConstraints();
		constraints.gridx = 1;		
		constraints.gridy = 1;		
		constraints.gridwidth = 3;
		constraints.weightx = 2.0;	
		constraints.fill = GridBagConstraints.BOTH;  	
		thisPanel.add(wuerfel[3], constraints);

		wuerfel[4] = new JLabel("0", iconb, JLabel.CENTER);
		wuerfel[4].setHorizontalTextPosition(0);
		wuerfel[4].setForeground(Color.WHITE);
		wuerfel[4].setFont(batman);
		wuerfel[4].setDisabledIcon(icong);
		constraints = new GridBagConstraints();
		constraints.gridx = 3;		
		constraints.gridy = 1;		
		constraints.gridwidth = 3;
		constraints.weightx = 2.0;
		constraints.fill = GridBagConstraints.BOTH;  	
		thisPanel.add(wuerfel[4], constraints);

		thisPanel.setPreferredSize(new Dimension(250,190));

		return thisPanel;    
	}

	/**
	 * Setzt alle Wrfel auf 0
	 */
	protected static void reset() {
		for(int i=0; i<5; i++) {
			wuerfel[i].setText("");
			wuerfel[i].setEnabled(true);
		}
	}

	/**
	 * Setzt einen Wrfel als inaktiv
	 * @param wuerfel zu deaktivierender Wrfel
	 */
	protected static void deaktiviere(int wuerfel) {
		WuerfelPanel.wuerfel[wuerfel].setText("");
		WuerfelPanel.wuerfel[wuerfel].setEnabled(false);
	}

	/**
	 * Setzt die Zahl eines Wrfels
	 * 
	 * @param wuerfel Nummer des Wrfelzs
	 * @param wert Gewrfelte Zahl
	 */
	protected static void setZahl(int wuerfel, int wert) {
		WuerfelPanel.wuerfel[wuerfel].setText(wert+"");
	}

}
