package risiko.local.ui.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

/**
 * Erstellt das KartenPanel
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public abstract class KartenPanel {
	
	/**
	 * Die Ausgabefelder fr Karten und Missionen
	 */
	protected static JTextArea karten, mission;
	private static GridBagConstraints constraints; 
	
	/**
	 * Erstellt das Karten-panel
	 * 
	 * @return KartenPanel
	 */
	protected static JPanel create() {
		
		JPanel thisPanel = new JPanel(new GridBagLayout());
		thisPanel.setOpaque(false);
		
		Font batman;
		try {
			batman = Font.createFont(Font.PLAIN, new File("batman.ttf"));
		} catch (FontFormatException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		} catch (IOException e) {
			batman = new Font("Verdana",Font.BOLD,16);
		}
		
		//berschrift "Karten" setzen
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.weightx = 1.0;
		constraints.fill = GridBagConstraints.BOTH;
        JLabel kartenlabel = new JLabel("=:.Karten.:=");
        kartenlabel.setFont(batman.deriveFont(Font.PLAIN, 16));
        kartenlabel.setHorizontalAlignment(JLabel.CENTER);
        kartenlabel.setForeground(Color.WHITE);
        thisPanel.add(kartenlabel, constraints);
		
		
        karten = new JTextArea("=:.Karten.:=");
        
        karten.setEditable(false);
        karten.setLineWrap(true);
        karten.setColumns(18);
        
        //neu von Hendrik 23.06.09 19:42
        //Schrift ndern
        karten.setFont(batman.deriveFont(Font.PLAIN, 16));   
        
		//berschrift "Mission" setzen
		constraints = new GridBagConstraints();
		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.weightx = 1.0;
		constraints.fill = GridBagConstraints.BOTH;
        JLabel missionlabel = new JLabel("=:.Mission.:=");
        missionlabel.setFont(batman.deriveFont(Font.PLAIN, 16));
        missionlabel.setHorizontalAlignment(JLabel.CENTER);
        missionlabel.setForeground(Color.WHITE);
        thisPanel.add(missionlabel, constraints);
          
        mission = new JTextArea("=:.Mission.:=");
        
        mission.setEditable(false);
        mission.setLineWrap(true);
        mission.setColumns(20);
        
        //neu von Hendrik 23.06.09 19:42
        //Schrift ndern
        mission.setFont(batman.deriveFont(Font.PLAIN, 16));
        
		constraints = new GridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.weightx = 1.0;
		constraints.weighty = 1.0;
		constraints.gridwidth = 2;
		constraints.fill = GridBagConstraints.BOTH;
        
        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,karten,mission);
        splitPane.setPreferredSize(new Dimension(500,175));
        splitPane.setDividerLocation(250);
        splitPane.setOneTouchExpandable(false);
        splitPane.setEnabled(false);
        
        thisPanel.add(splitPane, constraints);
        
        return thisPanel;
        
	}

}
