package risiko.local.ui.gui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JComponent;

/**
 * Klickbild zur Erkennung des Klicken auf die Lnder
 * 
 * @author dgrosche
 * @version 2009-06-20
 *
 */
public class Hintergrundbild extends JComponent {

	/**
	 * Automatisch generierte Versions-ID
	 */
	private static final long serialVersionUID = -819891242450001284L;
	
	private BufferedImage klickbild; //Bild das je nach Farbe klickbar ist
	private BufferedImage hintergrund; //anzuzeigendes Hintergrundbild
	
	/**
	 * Legt ein neues Hintergrundbild an
	 * @throws IOException , wenn Bilddateien nicht vorhanden sind
	 */
	protected Hintergrundbild() throws IOException {
		klickbild = ImageIO.read(new File("images/welt.png"));
		hintergrund = ImageIO.read(new File("images/hintergrund.png"));
		//setPreferredSize(new Dimension(bild.getWidth(),bild.getHeight()));
	}
	
	/**
	 * Zeichnet das Hintergrundbild in der Komponente
	 */
	public void paint(Graphics g) {
		g.drawImage(hintergrund, 0, 0, this);
	}
	
	/**
	 * Liest die Farbe des Klickbildes aus
	 * 
	 * @param x x-Koordinate des Bildes
	 * @param y y-Koordinate des Bildes
	 * @return Farbe des Pixels an dem gewhlten Punkt
	 */
	protected int getRGB(int x, int y) {
		return klickbild.getRGB(x, y);
	}
	
	
}
