package risiko.local.ui.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.IOException;
import java.util.Hashtable;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * Hauptfenster, dient als Hauptprogrammklasse.
 * 
 * @author hhollstein
 * @version 2009-06-25
 *
 */
public class Fenster {

	private static EventMgr eventListener;
	private static JPanel menuPanel;

	/**
	 * Hauptfenster als statisches Element
	 */
	protected static JFrame frame;

	/**
	 * Alle Wichtigen Komponenten des Fensters 
	 */
	protected Hashtable<String,JComponent> wichtigeKomponenten;

	/**
	 * Kontruktor: Ein Objekt dieser Klasse beinhaltet lediglich wichtige Komponenten
	 */
	protected Fenster() {
		wichtigeKomponenten = new Hashtable<String,JComponent>();
		wichtigeKomponenten.put("MenuPanel",menuPanel);
		wichtigeKomponenten.put("Mission",KartenPanel.mission);
		wichtigeKomponenten.put("Karten",KartenPanel.karten);
		wichtigeKomponenten.put("Historie",InfoPanel.ausgabe1);
		wichtigeKomponenten.put("Information",InfoPanel.ausgabe2);
		wichtigeKomponenten.put("Fehler",InfoPanel.ausgabe3);
	}

	/**
	 * Erstellt die grafische Oberflche des Frames
	 * @throws IOException 
	 */
	private static void erstelleGUI() throws IOException {
		frame = new JFrame("Risiko");

		//neu von Hendrik 25.06.09
		//			frame.setUndecorated(true);//schaltet die titelleiste etc. aus

		//neu von Hendrik 02.07.09
		ImageIcon icon = new ImageIcon("images/Fenster_Hintergrund.png");
		Image backImage = icon.getImage();
		BackgroundImagePanel contentPane = new BackgroundImagePanel();
		contentPane.setBackgroundImage(backImage);
		frame.setContentPane(contentPane);
		frame.setLayout(new BorderLayout());

		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setPreferredSize(new Dimension(1280,773));
		frame.setResizable(false);
		frame.setIconImage(new ImageIcon("images/risiko.png").getImage());

		// Hauptpanel werden erstellt und hinzugefgt
		JPanel weltPanel = WeltPanel.create();
		JPanel infoPanel = InfoPanel.create();
		menuPanel = MenuPanel.create();
		JPanel kartenPanel = KartenPanel.create();
		JPanel wuerfelPanel = WuerfelPanel.create();

		JPanel southPanel = new JPanel(new GridBagLayout());
		JPanel restPanel = new JPanel(new GridLayout(1,2));
		southPanel.setPreferredSize(new Dimension(1280,190));

		restPanel.setOpaque(false);
		southPanel.setOpaque(false);

		// MenuPanel und KartenPanel zu RestPanel
		restPanel.setPreferredSize(new Dimension(1024,190));
		restPanel.add(menuPanel);
		restPanel.add(kartenPanel);

		// RestPanel zu SouthPanel mit folgenden Eigenschaften
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;		// 0. Spalte
		c.weightx = 1.0;	// Flle horizontalen Platz aus
		c.fill = GridBagConstraints.BOTH;	// Mach die Komponente so gro wie mglich
		southPanel.add(restPanel,c);

		// WuerfelPanel zu SouthPanel mit folgenden Eigenschaften
		c = new GridBagConstraints();
		c.gridx = 2;		//2. Spalte
		c.weighty = 1.0;	// Flle vertikalen Platz aus
		c.anchor = GridBagConstraints.LINE_END; // Diese Komponente soll rechtsbndig sein
		southPanel.add(wuerfelPanel,c);

		frame.getContentPane().add(weltPanel,BorderLayout.WEST);
		frame.getContentPane().add(infoPanel,BorderLayout.EAST);
		frame.getContentPane().add(southPanel,BorderLayout.SOUTH);

		frame.pack();
		frame.setVisible(true);

		erstelleListener();
	}

	/**
	 * Legt den Event-Manager an, bergibt ihm die wichtigen Komponenten und
	 * fgt ihn als Listener fr klickbare Komponenten hinzu 
	 */
	private static void erstelleListener() {

		eventListener = new EventMgr(new Fenster());

		WeltPanel.klickBild.addMouseListener(eventListener);

		MenuPanel.angriffButton.setActionCommand("Angriffspanel");
		MenuPanel.angriffButton.addActionListener(eventListener);
		MenuPanel.verschiebeButton.setActionCommand("Transferpanel");
		MenuPanel.verschiebeButton.addActionListener(eventListener);
		MenuPanel.beendenButton.setActionCommand("Beenden");
		MenuPanel.beendenButton.addActionListener(eventListener);

		MenuPanel.speichern.setActionCommand("Speichern");
		MenuPanel.speichern.addActionListener(eventListener);
		MenuPanel.laden.setActionCommand("Laden");
		MenuPanel.laden.addActionListener(eventListener);

		MenuPanel.starten.get("Angriff").setActionCommand("Angriff");
		MenuPanel.starten.get("Angriff").addActionListener(eventListener);
		MenuPanel.starten.get("aAbbruch").setActionCommand("Abbrechen");
		MenuPanel.starten.get("aAbbruch").addActionListener(eventListener);
		MenuPanel.starten.get("Transfer").setActionCommand("Transfer");
		MenuPanel.starten.get("Transfer").addActionListener(eventListener);
		MenuPanel.starten.get("tAbbruch").setActionCommand("Abbrechen");
		MenuPanel.starten.get("tAbbruch").addActionListener(eventListener);
		MenuPanel.starten.get("Verteidigung").setActionCommand("Verteidigung");
		MenuPanel.starten.get("Verteidigung").addActionListener(eventListener);
		MenuPanel.starten.get("Verstaerkung").setActionCommand("Verstaerkung");
		MenuPanel.starten.get("Verstaerkung").addActionListener(eventListener);

		KartenPanel.karten.addMouseListener(eventListener);

	}

	/**
	 * Hauptklasse
	 * @param args
	 */
	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					erstelleGUI();
				} catch (IOException e) {
					System.err.println(e);
				}
			}
		});
	}



}
