package risiko.local.ui.gui;

import java.awt.Graphics;
import java.awt.Image;

import javax.swing.JComponent;

/**
 * Erstellt eine Hintergrundbild-Komponente
 * 
 * @author hhollstein
 * @version 2009-07-01
 *
 */
public class BackgroundImagePanel extends JComponent {
	 
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 2727836425880642455L;
	private Image backgroundImage = null;
 
	/**
	 * Returns the background image
	 * @return	Background image
	 */
	protected Image getBackgroundImage() {
		return backgroundImage;
	}
 
	/**
	 * Sets the background image
	 * @param backgroundImage	Background image
	 */
	protected void setBackgroundImage(Image backgroundImage) {
		this.backgroundImage = backgroundImage;
	}
	
	/**
	 * Overrides the painting to display a background image
	 */
	protected void paintComponent(Graphics g) {
		if (isOpaque()) {
			g.setColor(getBackground());
			g.fillRect(0, 0, getWidth(), getHeight());
		}
		if (backgroundImage != null) {
			g.drawImage(backgroundImage,0,0,this);
		}
	}
 
}
