package risiko.local.ui.cui;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Ereignisverarbeitung fr Hauptfenster
 * 
 * @author dgrosche
 * @version 2009-05-31
 *
 */
public class Listeners {
	
	/**
	 * Verarbeitet Fenster-Ereignisse
	 */
	public FrameListener window;
	
	/**
	 * Verarbeitet Button-Ereignisse
	 */
	public ButtonListener button;
	
	/**
	 * Verarbeitet Tastatur-Ereignisse
	 */
	public KeyListener enter;
	
	/**
	 * Eingabefeld
	 */
	public TextField eingabe;
	
	/**
	 * Ausgabe-CUI
	 */
	public CUI konsole;

	/**
	 * Konstruktor erstellt Listener
	 */
	public Listeners() {
		window = new FrameListener();
		button = new ButtonListener();
		enter  = new Keyboard();
	}
	
	/**
	 * Setzt CUI auf den Wert  
	 * 
	 * @param clui Command-Line User-Interface
	 */
	public void setKonsole(CUI clui) {
		konsole = clui;
	}
	
	/**
	 * Setzt zu berwachendes Eingabefeld 
	 * 
	 * @param in Eingabetextfeld
	 */
	public void setEingabe(TextField in) {
		eingabe = in;
	}
	
	/**
	 * Unterklasse fr Fenstereereignisse
	 */
	public class FrameListener extends WindowAdapter {
		
		public void windowClosing(WindowEvent e) {
			e.getWindow().dispose();                   // Fenster "killen"
			System.exit(0);                            // VM "killen" 
		}    	
	}
	
	/**
	 * Unterklasse fr Buttonereignisse
	 */
	public class ButtonListener implements ActionListener {

		@Override
		public void actionPerformed(ActionEvent e) {
			konsole.in = eingabe.getText();
			konsole.weiter = true;
			eingabe.setText("");
			synchronized(konsole) {
				konsole.notify();
			}
		}
		
	}
	
	/**
	 * Unterklasse fr Tastaturereignisse
	 */
	public class Keyboard implements KeyListener {

		@Override
		public void keyPressed(KeyEvent e) {
			if(e.getKeyCode()==KeyEvent.VK_ENTER) {
				if(!konsole.weiter) {
					konsole.in = eingabe.getText();
					konsole.weiter = true;
					eingabe.setText("");
					synchronized(konsole) {
						konsole.notify();
					}
				}
			}
			if(e.getKeyCode()==KeyEvent.VK_ESCAPE) {
				System.exit(0);
			}
			
		}

		@Override
		public void keyReleased(KeyEvent e) {
//			if(e.getKeyCode()==KeyEvent.VK_ENTER) {
//				konsole.in = eingabe.getText();
//				konsole.weiter = true;
//				eingabe.setText("");
//				synchronized(konsole) {
//					konsole.notify();
//				}
//			}
			
		}

		@Override
		public void keyTyped(KeyEvent e) {
//			if(e.getKeyCode()==KeyEvent.VK_ENTER) {
//				konsole.in = eingabe.getText();
//				konsole.weiter = true;
//				eingabe.setText("");
//				synchronized(konsole) {
//					konsole.notify();
//				}
//			}
			
		}
		
	}

}
