package risiko.local.ui.cui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;

import javax.swing.ImageIcon;

/**
 * Ausgabefenster fr CUI
 * 
 * @author dgrosche
 * @version 2009-05-31
 *
 */
public class Konsole extends Frame {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 269315450107111949L;
	
	private Listeners listeners;
	private TextField eingabe;
	private TextArea ausgabe;
	private Button senden;
	
	/**
	 * CUI-Thread der fr die Ausgabe zustndig ist
	 */
	public CUI konsole;

	/**
	 * Hauptprogramm
	 * 
	 * @param args der Vollstndigkeit halber, ohne Wirkung
	 */
	public static void main(String[] args) {
		Konsole myFrame = new Konsole("Konsolen-Risiko");
		while(myFrame.konsole.isAlive()) ;
		myFrame.dispose();
		System.exit(0);
	}
	
	/**
	 * Konstruktor fr Fenster
	 * 
	 * @param titel Fenster-Titel
	 */
	public Konsole(final String titel) {
		super(titel);
		listeners = new Listeners();
		this.initialisiere();
		konsole = new CUI(ausgabe,senden);
		listeners.setEingabe(eingabe);
		listeners.setKonsole(konsole);
		konsole.start();
	}
	
	/**
	 * Baut das Fenster auf
	 */
	private void initialisiere() {
		this.setLocation(100,100);
		this.setSize(800,600);
		this.setResizable(false);
		this.addWindowListener(listeners.window);
		this.addKeyListener(listeners.enter);
		this.setLayout(new BorderLayout());
		this.setIconImage(new ImageIcon("images/risiko.png").getImage());

		Container center = new Container();
		//center.setLayout(new FlowLayout());
		center.setSize(800,520);
		this.add(center, BorderLayout.CENTER);
		
		Container leiste = new Container();
		leiste.setLayout(new FlowLayout());
		leiste.setSize(800,80);
		this.add(leiste, BorderLayout.SOUTH);
		
		ausgabe = new TextArea("",0,0,TextArea.SCROLLBARS_NONE);
		ausgabe.setFocusable(false);
		ausgabe.setSize(800,520);
		ausgabe.setFont(new Font("Courier",0,14));
		center.add(ausgabe);
		
		eingabe = new TextField();
		eingabe.setColumns(100);
		eingabe.addKeyListener(listeners.enter);
		leiste.add(eingabe);
		
		senden = new Button("Senden");
		senden.addActionListener(listeners.button);
		senden.addKeyListener(listeners.enter);
		senden.setEnabled(false);
		leiste.add(senden);
		
		this.setVisible(true);
	}

}
