/**
 * 
 */
package risiko.local.persistence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

import risiko.local.domain.SpielerMgr;
import risiko.local.domain.WeltMgr;

/**
 * Persistenz-Verwaltung
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class PersMgr {
	
	private FilePers dateispeicherung;
	private Vector<Object> objekte;
	private Vector<String> zeilen;
	
	/**
	 * Speichert einen Spielstand
	 * 
	 * @param objects Liste mit zu speichernden Objekten
	 * @throws FileNotFoundException , wenn Datei nicht existiert
	 * @throws IOException , wenn Fehler beim Ein-/Auslesen der Datei
	 */
	public void speichern(Vector<Object> objects) throws FileNotFoundException, IOException {
		dateispeicherung = new FilePers();
		for(Object o : objects) {
			dateispeicherung.objektSpeichern(o);
		}
		dateispeicherung.close();
	}
	
	/**
	 * Ldt den letzten Spielstand
	 * 
	 * @throws FileNotFoundException , wenn Datei nicht vorhanden
	 * @throws IOException , wenn Fehler beim Ein-/Auslesen
	 * @throws ClassNotFoundException , wenn Klasse sich in der Zwischenzeit gendert hat
	 */
	public void laden() throws FileNotFoundException, IOException, ClassNotFoundException {
		dateispeicherung = new FilePers();		
		objekte = dateispeicherung.objektLaden();
	}
	
	/**
	 * Ldt Welt aus Datei
	 * 
	 * @throws FileNotFoundException , wenn Datei nicht vorhanden
	 * @throws IOException , wenn Fehler beim Lesen
	 */
	public void dateiLaden() throws FileNotFoundException, IOException {
		dateispeicherung =  new FilePers();
		zeilen = dateispeicherung.zeilenLaden("welt.sav");
	}
	
	/**
	 * @return geladene Spieler-Verwaltung
	 */
	public SpielerMgr getSpieler() {
		SpielerMgr erg = null;
		for(Object o : objekte) {
			if(o instanceof SpielerMgr) {
				erg =(SpielerMgr) o;
			}
		}
		return erg;
	}
	
	/**
	 * @return geladene Welt-Verwaltung
	 */
	public WeltMgr getWelt() {
		WeltMgr erg = null;
		for(Object o : objekte) {
			if(o instanceof WeltMgr) {
				erg = (WeltMgr) o;
			}
		}
		return erg;
	}
	
	/**
	 * Gibt Zeilen-Vektor eines bestimmten Typs wieder
	 * 
	 * @param typ erstes Zeichen nach dem Typ unterschieden wird
	 * @return Vektor mit Zeilen ohne Anfangszeichen
	 */
	public Vector<String> getSubstring(char typ) {
		Vector<String> erg = new Vector<String>();
		for(String zeile : zeilen) {
			if(zeile.charAt(0)==typ) {
				erg.add(zeile.substring(2));
			}
		}
		return erg;
	}

	
}
