/**
 * 
 */
package risiko.local.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

/**
 * Dateipersistenz
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class FilePers {
	
	private ObjectOutputStream oos;
	private ObjectInputStream ois;
	private BufferedReader br;
	private int anz;
	
	/**
	 * Erstellt eine neue Dateipersistenz
	 * 
	 * @throws FileNotFoundException , wenn Datei nicht gefunden
	 * @throws IOException , wenn Fehler beim Ein-/Auslesen
	 */
	public FilePers() throws FileNotFoundException, IOException {
		//Es wird von 100 mglichen Spielstnden runtergzhlt und geschaut welcher der letzte ist
		int i = 100;
		File datei = new File("scores/spielstand"+i+".ser");
		while((!datei.exists())&&(i>=0)) {
			datei = new File("scores/spielstand"+i+".ser");
			i--;
		}
		anz = i+1;
	}

	/**
	 * Speichert Objekt in aktueller Spielstand-Datei
	 * 
	 * @param o zu serialisierendes Objekt
	 * @throws IOException , wenn Fehler beim ffnen der Datei
	 */
	public void objektSpeichern(Object o) throws IOException {
		if(oos==null) oos = new ObjectOutputStream(new FileOutputStream("scores/spielstand"+(anz+1)+".ser"));
		oos.writeObject(o);
		oos.flush();
	}
	
	/**
	 * Schliet aktuelle Spielstand-Datei
	 * 
	 * @throws IOException , wenn Fehler beim Schlieen
	 */
	public void close() throws IOException {
		oos.close();
	}
	
	/**
	 * Ldt Objekte aus aktueller Spielstand-Datei
	 * 
	 * @return Liste mit serialisierten Objekten
	 * @throws FileNotFoundException , wenn Datei nicht vorhanden
	 * @throws IOException , wenn Fehler beim Lesen
	 * @throws ClassNotFoundException , wenn nicht serialisierbar oder Versionsfehler
	 */
	public Vector<Object> objektLaden() throws FileNotFoundException, IOException, ClassNotFoundException {
		ois = new ObjectInputStream(new FileInputStream("scores/spielstand"+anz+".ser"));
		Vector<Object> erg = new Vector<Object>();
		erg.add(ois.readObject());
		erg.add(ois.readObject());
		return erg;
	}
	
	/**
	 * Ldt Zeilen aus Text-Datei
	 * 
	 * @param datei zu lesende Datei
	 * @return Vektor mit einzelnen Zeilen
	 * @throws IOException , wenn Fehler beim Lesen der Datei
	 */
	public Vector<String> zeilenLaden(String datei) throws IOException {
		Vector<String> erg = new Vector<String>();
		br = new BufferedReader(new FileReader(datei));
		String ende = "";
		while (ende!=null) {
			ende = br.readLine();
			if(ende!=null) erg.add(ende);
		}
		br.close();
		return erg;
	}

}
