package risiko.local.domain.exceptions;

import java.util.Vector;

import risiko.local.valueobjects.Land;
import risiko.local.valueobjects.Spieler;

/**
 * Spieler hat nicht gengend Einheiten 
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class NichtGenugEinheitenException extends Exception {
	
	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 9137824122090775481L;
	
	private Spieler besitzer;
	private boolean kampf;
	private Vector<Integer> wuerfel;
	
	/**
	 * Konstruktor aus einem Kampf heraus
	 * 
	 * @param a Land, welches nicht gengend Einheuten hat
	 * @param k Tritt der Fehler in einem Kampf auf?
	 * @param wA Wrfelzahlen des Angreifers
	 */
	public NichtGenugEinheitenException(Land a, boolean k, Vector<Integer> wA) {
		super(a.getBesitzer()+" hat nicht gengend Einheiten in "+a.getName());
		this.besitzer = a.getBesitzer();
		kampf = k;
		wuerfel = wA;
	}
	
	/**
	 * Konstruktor aus der Welt heraus
	 * 
	 * @param a Land, welches nicht gengend Einheiten hat
	 */
	public NichtGenugEinheitenException(Land a) {
		super(a.getBesitzer()+" hat nicht gengend Einheiten in "+a.getName());
	}

	/**
	 * Gibt zuck ob Besitzer des Landes aktiver Spieler ist und lscht 
	 * bei Bedarf die Wrfelzahlen des Angreifers.
	 *
	 * @return true, wenn Spieler dran
	 */
	public boolean behandle() {
		if(kampf) {
			boolean erg = besitzer.isDran();
			if(!erg) {
				wuerfel.removeAllElements();
			}
			return erg;
		}
		return false;
	}

}
