package risiko.local.domain.exceptions;

import risiko.local.valueobjects.Land;
import risiko.local.valueobjects.Spieler;

/**
 * Land gehrt nicht dem aktiven Spieler
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class LandNichtImBesitzException extends Exception {

	/**
	 * Konstruktor
	 * 
	 * @param a Land das nicht im Besitz des aktiven Spielers ist
	 * @param aktiverSpieler aktiver Spieler
	 */
	public LandNichtImBesitzException(Land a, Spieler aktiverSpieler) {
		super(a +" ist im Besitz von "+a.getBesitzer()+", nicht von "+aktiverSpieler+".");
	}

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -9196935268950469979L;

}
