package risiko.local.domain.exceptions;

import risiko.local.valueobjects.Land;

/**
 * Fehler, wenn ein Land nicht die gesuchten Nachbarn hat
 * 
 * @author dgrosche
 * @version 2009-05-12
 *
 */
public class KeineNachbarnException extends Exception {

	/**
	 * Konstruktor
	 * 
	 * @param a Land, das keine Nachbarn hat
	 * @param i fremde oder eigene Nachbarn?
	 */
	public KeineNachbarnException(Land a, boolean i) {
		super("Fr "+a+" gibt es keine "+((i)?"fremden":"eigenen")+" Nachbarn!");
	}

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = 1337133750717253091L;

}
