package risiko.local.domain;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

import risiko.local.domain.exceptions.LandNichtImBesitzException;
import risiko.local.valueobjects.Land;
import risiko.local.valueobjects.Spieler;

/**
 * Verwaltet Spieler und Logik des Spielers, d.h. hier werden die Aktionen
 * des Spielers ausgefhrt.
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class SpielerMgr implements Serializable {

	/**
	 * Serielle Versions-ID
	 */
	private static final long serialVersionUID = -7341580337650926196L;
	
	private Spieler aktiverSpieler;								//Aktiver Spieler
	private Vector<Spieler> spieler  = new Vector<Spieler>();	//Alle Spieler
		
	/**
	 * Fgt einen Spieler hinzu.
	 * 
	 * @param spielername Name des Spielers
	 */
	public void addSpieler(String spielername) {
		spieler.add(new Spieler(spielername));
	}
	
	/**
	 * Setzt beim aktiven Spieler, dran auf false 
	 * und beim nchsten Spieler in der Reihe dran auf true,
	 * sowie diesen als aktiverSpieler
	 */
	public void beendeZug() {
		pruefSpieler();
		int index = spieler.indexOf(this.getAktiverSpieler());
		if(!(spieler.elementAt(index).equals(spieler.lastElement()))) {
			spieler.elementAt(index).setDran(false);
			spieler.elementAt(index+1).setDran(true);
		} else {
			spieler.elementAt(index).setDran(false);
			spieler.firstElement().setDran(true);
		}
		this.setAktiverSpieler();
	}
	
	/**
	 * Gibt den aktiven Spieler zurck
	 * 
	 * @return Spieler, der dran ist.
	 */
	public Spieler getAktiverSpieler() {
		this.setAktiverSpieler();
		return this.aktiverSpieler;
	}
	
	/**
	 * Gibt alle Spieler zurck.
	 * 
	 * @return Vektor mit allen Spielern
	 */
	public Vector<Spieler> getAllSpieler() {
		return this.spieler;
	}
	
	/**
	 * Prft ob noch alle Spieler Lnder besitzen und kickt diese sonst raus
	 */
	private void pruefSpieler() {
		Vector<Spieler> loeschliste = new Vector<Spieler>();
		for(Spieler p : spieler) {
			if(p.getAnzLaender()==0) {
				loeschliste.add(p);
			}
		}
		for (Spieler p : loeschliste) {
			spieler.removeElement(p);
		}
	}
	
	/**
	 * Setzt den ersten Spieler mit der Eigenschaft dran, als aktiven Spieler ein.
	 */
	private void setAktiverSpieler() {
		Iterator<Spieler> iter = spieler.iterator();
		while(iter.hasNext()) {
			Spieler einSpieler = iter.next();
			if(einSpieler.isDran()) {
				this.aktiverSpieler = einSpieler;
			}
		}
	}
	
	/**
	 * Es werden anzEinheiten ins Land a gesetzt
	 * 
	 * @param a Zielland 
	 * @param anzEinheiten Anzahl der zustzlichen Einheiten
	 * @throws LandNichtImBesitzException , wenn A nicht im Besitz des aktiven Spielers.
	 */
	public void setzeEinheiten(Land a, int anzEinheiten) throws LandNichtImBesitzException {

		if(!a.getBesitzer().equals(this.aktiverSpieler)) {
			throw new LandNichtImBesitzException(a, aktiverSpieler);
		} else {
			a.setAnzEinheiten(a.getAnzEinheiten()+anzEinheiten);
		}
		
	}
	

}
