package risiko.local.domain;

import java.util.Vector;

import risiko.local.valueobjects.BefreiungsMission;
import risiko.local.valueobjects.KontinentMission;
import risiko.local.valueobjects.LaenderMission;
import risiko.local.valueobjects.Land;
import risiko.local.valueobjects.Mission;
import risiko.local.valueobjects.Spieler;

/**
 * Verwaltet alle Missionen
 * 
 * @author dgrosche
 * @version 2009-05-25
 *
 */
public class MissionsMgr {
	
	private Vector<Mission> missionsliste;
	private WeltMgr welt;
	
	/**
	 * Erstellt alle Missionen
	 * 
	 * @param welt vorhandene Welt
	 * @param spielerliste alle Spieler
	 */
	public MissionsMgr(WeltMgr welt, Vector<Spieler> spielerliste) {
		this.welt = welt;
		missionsliste = new Vector<Mission>();
		createKontinentMissionen();
		createLaenderMissionen();
		createBefreiungsMissionen(spielerliste);
	}
	
	/**
	 * Befreiungsmissionen werden fr jeden Spieler erstellt
	 * 
	 * @param spielerliste alle aktiven Spieler
	 */
	private void createBefreiungsMissionen(Vector<Spieler> spielerliste) {
		BefreiungsMission m;
		for(Spieler p : spielerliste) {
			m = new BefreiungsMission(p);
			m.setSpielerliste(spielerliste);
			m.setMessage("Befreien Sie alle Lnder des Spielers "+p);
			missionsliste.add(m);
		}
	}
	
	/**
	 * Kontinentenmissionen werden erstellt
	 */
	private void createKontinentMissionen() {
		KontinentMission m = new KontinentMission(2); 
		m.setMessage("Befreien Sie Nordamerika und Afrika!");
		m.addKontinent(welt.getKontinentenliste().elementAt(0));
		m.addKontinent(welt.getKontinentenliste().elementAt(3));
		missionsliste.add(m);
		
		m = new KontinentMission(2); 
		m.setMessage("Befreien Sie Nordamerika und Australien!");
		m.addKontinent(welt.getKontinentenliste().elementAt(0));
		m.addKontinent(welt.getKontinentenliste().elementAt(5));
		missionsliste.add(m);
		
		m = new KontinentMission(2); 
		m.setMessage("Befreien Sie Asien und Sdamerika!");
		m.addKontinent(welt.getKontinentenliste().elementAt(1));
		m.addKontinent(welt.getKontinentenliste().elementAt(4));
		missionsliste.add(m);
		
		m = new KontinentMission(2); 
		m.setMessage("Befreien Sie Afrika und Asien!");
		m.addKontinent(welt.getKontinentenliste().elementAt(3));
		m.addKontinent(welt.getKontinentenliste().elementAt(4));
		missionsliste.add(m);
		
		m = new KontinentMission(3); 
		m.setMessage("Befreien Sie Europa, Sdamerika und einen weiteren Kontinenten!");
		m.addKontinent(welt.getKontinentenliste().elementAt(1));
		m.addKontinent(welt.getKontinentenliste().elementAt(2));
		m.setKontinentenliste(welt.getKontinentenliste());
		missionsliste.add(m);
		
		m = new KontinentMission(3); 
		m.setMessage("Befreien Sie Europa, Australien und einen weiteren Kontinenten!");
		m.addKontinent(welt.getKontinentenliste().elementAt(2));
		m.addKontinent(welt.getKontinentenliste().elementAt(5));
		m.setKontinentenliste(welt.getKontinentenliste());
		missionsliste.add(m);
	}
	
	/**
	 * Lndermissionen werden erstellt
	 */
	private void createLaenderMissionen() {
		LaenderMission m = new LaenderMission(24,1);
		m.setMessage("Befreien Sie 24 Lnder Ihrer Wahl!");
		missionsliste.add(m);
		
		m = new LaenderMission(18,2);
		m.setMessage("Befreien Sie 18 Lnder und setzen Sie in jedes Land min. 2 Armeen!");
		m.setLaenderliste(welt.getLaenderliste());
		missionsliste.add(m);
	}
	
	/**
	 * Gibt die Missionsliste zurck
	 * 
	 * @return the missionsliste
	 */
	public Vector<Mission> getMissionsliste() {
		return missionsliste;
	}
	
	/**
	 * Prft alle Missionen
	 */
	public void pruefMissionen() {
		welt.pruefKontinente();
		for(Mission m : missionsliste) {
			m.pruefErfuellt();
		}
	}
	
	/**
	 * Setzt zur Lndermission m eine Lnderliste
	 * 
	 * @param m Lndermission, die berprft werden soll
	 * @param laenderliste Lnderliste die berprft werden soll
	 */
	public void setLaenderliste(Mission m, Vector<Land> laenderliste) {
		if(m instanceof LaenderMission) {
			((LaenderMission) m).setLaenderliste(laenderliste);
		}
	}

}
