/**
 * 
 */
package game.gamestorage.texas.db;

import game.gamestorage.texas.db.SQLHandler;
import game.gamestorage.texas.db.SetterQuery;

import org.junit.Before;
import org.junit.Test;

import util.sql.ConnectionManager;

/**
 * @author Witthold/Korol
 */
public class DBHandlerTest extends SQLHandler {

	private static String driver = "com.mysql.jdbc.Driver";
	private static String databaseUrl = "jdbc:mysql://localhost:3306/pokerbot";
	private static String username = "pokerbot";
	private static String password = "asdfki";
	private static final int maxPoolSize = 3;


	//	protected SetterQuery q = new SetterQuery();

	public DBHandlerTest() {
		super();
		//		super(driver, databaseUrl, username, password, maxPoolSize);
		//		System.out.println("DBHandlerTest: Constructor");
	}


	@Before
	public void setup() {

	}


	//	@Test
	public void initDBHandlerTest() {
		System.out.println("DBHandlerTest: initHandTest");

	}


	//	@Test
	public void benchmarkQueryInsertCount() {

		int c = 30000;

		long a = System.currentTimeMillis();

		for (int i = 0; i < c; i++) {
			insertTournament("player");
			//			insertTournament("test1");
			//			insertTournament("test2");
			//			insertTournament("test3");
		}

		long b = System.currentTimeMillis();
		System.err.println("Total time of inserting " + c + " players: " + (b - a));

	}


	//	@Test
	public void benchmarkQueryInsertWhile() {

		long time = 10000;

		long a = System.currentTimeMillis();

		int inserts = 0;

		for (long i = a; i < (a + time); i = System.currentTimeMillis()) {
			insertTournament("player");
			//			insertTournament("test1");
			//			insertTournament("test2");
			//			insertTournament("test3");
			//			inserts += 4;
			inserts += 1;
		}

		System.err.println(inserts + " inserts in " + time + " ms");
		System.err.println(util.Helper.getTimeMS() + "  benchmarkQueryInsertWhile() finished ");
	}


	@Test
	public void emptyPlayerTest() {

		//		System.err.println(util.Helper.getTimeMS() + "  emptyPlayerTest() ");
		//		emptyTable("player");
		//		emptyTable("test1");
		//		emptyTable("test2");
		//		emptyTable("test3");

		new SQLHandler();
		new SQLHandler(driver, databaseUrl, username, password, maxPoolSize);

	}


	/*
	 * 
	 * 
	 * 
	 * 
	 */

	public void insertTournament(String tblName) {

		if (sqlSet(SetterQuery.insertPlayer(tblName))) {
			//			System.out.println(util.Helper.getTimeMS() + "  query success");
		} else {
			System.out.println(util.Helper.getTimeMS() + "  query false");
		}
	}


	public void emptyTable(String tblName) {

		if (sqlSet(SetterQuery.emptyTable(tblName))) {
			//			System.out.println(util.Helper.getTimeMS() + "  query success");
		} else {
			System.out.println(util.Helper.getTimeMS() + "  query false");
		}
	}

}
