package bot.module.shc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import game.model.Card;
import static util.poker.texas.PositionInt.*;

import org.junit.Before;
import org.junit.Test;

import bot.module.th.shc.TableLoose;


/**
 * @author Witthold/Korol
 */

/**
 * CSV startinghandchart </br>
 * custom table by importing own csv file </br>
 */
public class TableOffensiveTest extends TableLoose {
	
	protected Card[] holeCards = new Card[2];
	protected int bet, smallBlind, bigBlind, activePlayers;
	/** position classes: early,mid,late,sb,bb - 0-4 */
	protected int position;
	protected int calls, raises;

	public TableOffensiveTest() {
		
	}

	
	
	@Before
	public void setup() {
	
		simulateGameState();		
	}
	
	public void simulateGameState() {
		
//		hand = new HoleCards_TH(new Card("Ad"), new Card("Kd"));		// RAISE3 / 4
//		hand = new Hand(new Card("3d"), new Card("2h"));		// FOLD
//		hand = new Hand(new Card("Ad"), new Card("Ah"));		// RAISE3 / 4
		
		holeCards = new Card[2];
		
		holeCards[0] = new Card("As");
		holeCards[1] = new Card("4d");
		
		activePlayers = 2;
		smallBlind = 10;
		bigBlind = 20;
		position = 1;
		calls = 0;
		raises = 0;
	}

	
	@Test
	public void getBetTest() {
		
		System.out.println("TableTest: getBetTest");
		
		bet = getProposal(holeCards, activePlayers, smallBlind, bigBlind, position, calls, raises)[0];
		
		System.out.println("Bet via Table: " + bet);
		
		assertTrue(table.length > 3);
		assertEquals(table[14][3][13][3][4][4][3], 1);
		assertEquals(table[14][3][13][3][4][4][0], 4);	
		assertEquals(table[14][0][13][0][2][1][0], 4);	
		assertEquals(table[14][3][14][2][2][1][0], 4);	
		assertEquals(table[12][3][12][2][2][1][0], 4);		
		assertEquals(table[10][3][10][2][2][1][0], 4);		
		assertEquals(table[6][3][6][2][2][1][0], 1);
		assertEquals(table[6][3][6][2][2][2][0], -1);
		assertEquals(table[2][3][2][2][4][3][0], 0);
		assertEquals(table[1][3][2][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[1][3][1][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[0][3][1][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[4][3][1][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[2][1][3][3][2][1][0], -1);
		assertEquals(table[13][3][9][3][1][1][0], 1);	// k, 9 suited
		assertEquals(table[13][3][9][3][2][1][0], -1);	// k, 9 suited
		assertEquals(table[12][3][8][3][3][0][0], 4);	// q, 8 suited
		assertEquals(table[12][3][7][3][3][0][0], -1);	// q, 7 suited
	}
	

	//@Test
	public void getPositionCatTest() {
		
//		int pos = getPositionCat(6, 10);
//		assertEquals(MIDDLE, pos);
//		
//
//		pos = getPositionCat(0, 3);
//		assertEquals(SB, pos);
//		
//		pos = getPositionCat(0, 2);
//		assertEquals(SB, pos);
//
//		pos = getPositionCat(0, 22);
//		assertEquals(SB, pos);
//		
//		pos = getPositionCat(0, 5);
//		assertEquals(SB, pos);
//		
//		pos = getPositionCat(1, 5);
//		assertEquals(BB, pos);
//		
//		pos = getPositionCat(1, 2);
//		assertEquals(BB, pos);
//		
//		pos = getPositionCat(1, 23);
//		assertEquals(BB, pos);
//		
//		pos = getPositionCat(2, 3);
//		assertEquals(LATE, pos);
//		
//		pos = getPositionCat(2, 8);
//		assertEquals(EARLY, pos);
//		
//		pos = getPositionCat(4, 8);
//		assertEquals(MIDDLE, pos);
		
		
	}
	

}
