/**
 * 
 */
package bot.module.shc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import game.model.Card;

import org.junit.Before;
import org.junit.Test;

import bot.module.th.shc.TableCSV;



/**
 * @author Witthold/Korol
 */

/**
 * CSV startinghandchart </br>
 * custom table by importing own csv file </br>
 */
public class TableCSVTest extends TableCSV {
	
	protected Card[] holeCards = new Card[2];
	protected int bet, smallBlind, bigBlind, activePlayers;
	/** position classes: early,mid,late,sb,bb - 0-4 */
	protected int position;
	protected int calls, raises;

	public TableCSVTest() {
		super("Table_myTable.csv");
		//super("Table_Offensive.csv");
	}

	
	
	@Before
	public void setup() {
	
		simulateGameState();		
	}
	
	public void simulateGameState() {
		
//		hand = new HoleCards_TH(new Card("Ad"), new Card("Kd"));		// RAISE3 / 4
//		hand = new Hand(new Card("3d"), new Card("2h"));		// FOLD
//		hand = new Hand(new Card("Ad"), new Card("Ah"));		// RAISE3 / 4
		
		holeCards = new Card[2];
		holeCards[0] = new Card("Ad");
		holeCards[1] = new Card("Kd");
		
		activePlayers = 3;
		smallBlind = 10;
		bigBlind = 20;
		position = 3;
		calls = 1;
		raises = 0;
	}

	
	@Test
	public void getBetTest() {
		
		System.out.println("TableTest: getBetTest");
		
		bet = getProposal(holeCards, activePlayers, smallBlind, bigBlind, position, calls, raises)[0];
		
		System.out.println("Bet via Table: " + bet);
		
		assertTrue(table.length > 3);
		/* pairs */
		assertEquals(table[14][3][14][2][2][1][0], 4);	
		assertEquals(table[12][3][12][2][2][1][0], 4);
		assertEquals(table[10][3][10][2][2][1][0], 4);		
		assertEquals(table[6][3][6][2][2][1][0], 1);
		assertEquals(table[6][3][6][2][2][2][0], -1);
		assertEquals(table[2][3][2][2][4][3][0], 0);
		assertEquals(table[12][0][12][1][2][1][0], 4);
		assertEquals(table[12][0][12][1][2][1][0], 4);
		assertEquals(table[12][0][12][1][2][4][1], 4);				
		assertEquals(table[12][0][12][1][2][1][2], 4);					
		assertEquals(table[12][0][12][1][2][1][3], 1);				
		
		/* suited Aces */
		assertEquals(table[14][0][13][0][2][1][0], 4);					
		/* unsuited Aces */
		
		/* suited Kings */
		assertEquals(table[11][0][13][0][2][0][0], 4);					
		assertEquals(table[13][3][9][3][1][1][0], 1);	// k, 9 suited
		assertEquals(table[13][3][9][3][2][1][0], -1);	// k, 9 suited
		assertEquals(table[13][3][9][3][3][0][0], 4);	// k, 9 suited
		assertEquals(table[13][3][9][3][4][0][0], -2);	// k, 9 suited
		assertEquals(table[2][3][13][3][1][4][0], 1);	// k, 9 suited
		/* unsuited Kings */
		
		
		/* suited Queens */
		assertEquals(table[12][3][8][3][3][0][0], 4);	// q, 8 suited
		assertEquals(table[12][3][8][3][2][0][0], 4);	// q, 8 suited
		assertEquals(table[12][3][8][3][4][0][0], -2);	// q, 8 suited
		assertEquals(table[12][3][7][3][3][0][0], -1);	// q, 7 suited
		/* unsuited Queens */
		
		/* suited Jacks */
		assertEquals(table[11][3][8][3][3][0][0], 4);	// j, 8 suited
		assertEquals(table[11][3][8][3][2][0][0], -1);	// q, 8 suited
		assertEquals(table[11][3][8][3][4][0][0], -2);	// q, 8 suited
		assertEquals(table[11][3][7][3][3][0][0], -1);	// j, 7 suited
		/* unsuited Jacks */
		
		/* suited Tens */
		assertEquals(table[10][3][8][3][0][3][0], -2);	// t, 8 suited
		assertEquals(table[10][3][8][3][3][3][0], 1);	// t, 8 suited
		assertEquals(table[10][3][9][3][1][4][0], 1);	// t, 9 suited
		assertEquals(table[10][3][9][3][1][3][0], 1);	// t, 9 suited
		assertEquals(table[10][3][9][3][3][4][0], 1);	// t, 9 suited
		assertEquals(table[10][3][9][3][3][4][3], -1);	// t, 9 suited		
		assertEquals(table[10][3][7][3][3][0][0], -1);	// t, 7 suited
		assertEquals(table[5][3][10][3][3][0][0], -1);	// 5, t suited
		assertEquals(table[8][3][10][3][4][1][0], 0);	// 8, t suited
		/* unsuited Tens */
		
		/* suited Connectors */
		assertEquals(table[9][3][8][3][3][0][0], -1);	// q, 8 suited
		assertEquals(table[9][3][8][3][3][3][0], 1);	// q, 8 suited
		assertEquals(table[9][3][8][3][4][3][0], 0);	// q, 8 suited
		assertEquals(table[6][3][7][3][3][0][0], -1);	// q, 7 suited
		/* unsuited Connectors */
		assertEquals(table[2][1][3][3][2][1][0], -1);
		

		/* dead ranges */
		assertEquals(table[1][3][2][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[1][3][1][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[0][3][1][2][4][3][0], -2);	// dead range, not explicitly filled
		assertEquals(table[4][3][1][2][4][3][0], -2);	// dead range, not explicitly filled

		
		
	}
	

	

}
