/**
 * 
 */
package bot.module.shc;

import static org.junit.Assert.*;
import game.model.Card;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.Before;

import bot.module.th.shc.TableBSS;



/**
 * @author Witthold/Korol
 */

/**
 * BSS
 * defensiv
 * table from:
 * http://de.pokerstrategy.com/strategy/bss/1535/1
 */
public class TableBSSTest extends TableBSS {
	
	protected Card[] holeCards = new Card[2];
	protected int bet, smallBlind, bigBlind, activePlayers;
	/** position classes: early,mid,late,sb,bb - 0-4 */
	protected int position;
	protected int calls, raises;

	public TableBSSTest() {
		
	}	
	
	
	@Before
	public void setup() {
		
		simulateGameState();		
	}
	
	
	public void simulateGameState() {
		
//		hand = new Card{(new Card("Ad"), new Card("Kd"));		// RAISE3 / 4
		holeCards = new Card[2];
		holeCards[0] = new Card("Ad");
		holeCards[1] = new Card("Kd");
		
//		hand = new Hand(new Card("3d"), new Card("2h"));		// FOLD
//		hand = new Hand(new Card("Ad"), new Card("Ah"));		// RAISE3 / 4
		
		activePlayers = 3;
		smallBlind = 10;
		bigBlind = 20;
		position = 3;
		calls = 0;
		raises = 3;
	}
	
		
	@Test
	public void getBetTest() {
		
		System.out.println("TableBSSTest: getBetTest");
		

		bet = getProposal(holeCards, activePlayers, smallBlind, bigBlind, position, calls, raises)[0];
		
		System.out.println("Bet via Table: " + bet);
		
		assertTrue(table.length > 3);
		assertEquals(table[14][3][13][3][4][1][1], 3);
		assertEquals(table[14][3][13][3][4][1][0], 4);		
		assertEquals(table[14][3][13][3][2][1][0], 4);		
		assertEquals(table[2][1][3][3][2][1][0], -1);
	}
	

	

}
