package util.sql;

import game.model.Card;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * This class converts between different java datatypes 
 * 
 * @author Witthold/Korol
 *
 */
public class DBHelper {
	private DBHelper() {}	// no instanciation please
	
	
	/**
	 * extracts long[0] to HashMap key, long[>0] to value
	 *  
	 * @param al as ArrayList<long[]>
	 * @return HashMap<Integer, long[]>
	 */	
	public static HashMap<Integer, long[]> alToHmLong(ArrayList<long[]> al){
		
		HashMap<Integer, long[]> hm = new HashMap<Integer, long[]>();
				
		for (long[] is : al) {
			long[] ar = new long[is.length-1];
			
			for (int i = 0; i < ar.length; i++) {
				ar[i] = is[i+1];
			}	
			hm.put((int) is[0], ar);
		}		
		
		return hm;
	}
	
	/**
	 * extracts int[0] to HashMap key, int[>0] to value
	 *  
	 * @param al as ArrayList<int[]>
	 * @return HashMap<Integer, int[]>
	 */
	public static HashMap<Integer, int[]> alToHmInt(ArrayList<int[]> al){
		
		HashMap<Integer, int[]> hm = new HashMap<Integer, int[]>();
				
		for (int[] is : al) {
			int[] ar = new int[is.length-1];
			
			for (int i = 0; i < ar.length; i++) {
				ar[i] = is[i+1];
			}
			hm.put(is[0], ar);
		}		
		
		return hm;
	}
	
	
	/**
	 * converts cards db style to Card[]
	 *  
	 * @param cardsDB - cards in db format int[]
	 * @return Card[] cards
	 */
	public static Card[] cardsDBToCardArr(int[] cardsDB){
		
		Card[] cards = new Card[cardsDB.length];
		
		int[] ranks = new int[cards.length];
		int[] suits = new int[cards.length];

		// rank, suit mapping, // toCardArray	
		for (int i = 0; i < cards.length; i++) {
			ranks[i] = cardsDB[i] % 20;
			suits[i] = cardsDB[i] / 20;

			cards[i] = new Card(suits[i], ranks[i]);
			//				DebugOut.showVerboseUtil("suits[i]: " + suits[i] + ", ranks[i]: " + ranks[i] + " - card.toString(): " + card.toString());
		}	
		
		return cards;
	}
	
	
	/**
	 * converts card db style to Card
	 *  
	 * @param cardDB - one card in db format int
	 * @return Card card
	 */
	public static Card cardDBToCard(int cardDB){
				
		int rank = cardDB % 20;
		int suit = cardDB / 20;
			
		Card card = new Card(suit, rank);
//		DebugOut.showVerboseUtil("suit: " + suit + ", rank: " + rank + " - card.toString(): " + card.toString());
		
		return card;
	}

	

}
