package util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * Helping class for little useful methods
 * 
 * @author Witthold/Korol
 */

public class Helper {
	private Helper() {}	/* no instanciation please */

	public static boolean checkInt(String num) {
		try {
			char[] chars = num.toCharArray();
			int size = chars.length;
			for (int x = 0; x < size; x++) {
				if ((chars[x] > 57 || chars[x] < 48) || (x != 1 && chars[x] == '-'))
					return false;
			}
			double d = Double.parseDouble(num);
			if (d > Integer.MAX_VALUE || d < Integer.MIN_VALUE)
				return false;
			return true;

		} catch (NumberFormatException e) {
			System.err.println("Helper.checkInt: No int given: " + e);
			return false;
		}
	}


	public static String[] myStringTokenizer(String str, String delim) {
		try {
			//DebugOut.showVerboseUtil("myStringTokenizer - String: " + str);
			String[] tokens = str.split(delim);
			return tokens;
		} catch (Exception e) {
			System.err.println("Helper.myStringTokenizer: Problem while splitting String: " + e);
		}
		return null;
	}


	public static String getDateTime() {
		DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		Date date = new Date();
		return dateFormat.format(date);
	}


	public static String getTime() {
		DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
		Date date = new Date();
		return dateFormat.format(date);
	}


	public static String getTimeMS() {
		DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
		Date date = new Date();
		return dateFormat.format(date);
	}


	/**
	 * @param upper
	 * @return random int between 0(inclusive) and upper(exclusive)
	 */
	public static int getRandom(int upper) {
		int r;
		Random rand = new Random();
		r = rand.nextInt(upper);
		return r;
	}
}
