package game.gamestorage.texas.db;

import game.Action;
import game.gamestorage.texas.IF_SetGameStorageTH;
import game.model.Card;

import java.util.ArrayList;

/**
 * This class is the "java-side" part of the mapping form Java to database</br>
 * Responsable for writing to db
 * 
 * @author Witthold/Korol
 */
public class SetGameStorageTH_DB implements IF_SetGameStorageTH {

	SetterDBProjector sp = new SetterDBProjector();


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.IF_SetGameStorage#setGetGamedef(int, int, int, int, int, int)
	 */
	@Override
	public int setGetGamedef(int limited, int minBet, int maxBet, int numPlayers, int style, int buyin) {
		if (!sp.setGameDef(limited, minBet, maxBet, numPlayers, style, buyin)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db (setGamedef)");
			return -1;
		}
		return sp.getGamedef_id();
	}


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.IF_SetGameStorage#setStartCompetition(java.lang.String[], int[])
	 */
	@Override
	public void setStartCompetition(String[] players, int[] cash_init) {
		if (!sp.setCompetition()) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db (setCompetition)");
			return;
		}

		if (!sp.setPlayers(players)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db (setPlayers)");
			return;
		}
		if (!sp.setCompetitionPlayerMap(cash_init)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db (setCompetitionPlayerMap)");
			return;
		}
	}


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.texas.IF_SetGameStorageTH#setHand(int[], int, int, int, int[], game.model.Card[])
	 */
	@Override
	public void setHand(int[] position, int sb, int bb, int ante, int[] cashInit, Card[] holeCards) {
		if (!sp.setHand(sb, bb, ante)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
		if (!sp.setHandPlayerMap(position, cashInit)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
		if (!sp.setCardOfPlayer(holeCards)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
	}


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.texas.IF_SetGameStorageTH#setEndRound(long, java.util.ArrayList, game.model.Card[])
	 */
	@Override
	public void setEndRound(long timestamp, ArrayList<Action> betHistory, Card[] revealedBoardCards) {
		if (!sp.setBetHistory(timestamp, betHistory)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
		if (!sp.setCommonCards(revealedBoardCards)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
	}


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.texas.IF_SetGameStorageTH#setEndHand(int, int[], game.model.Card[][])
	 */
	@Override
	public void setEndHand(int finalpot, int[] cashDelta, Card[][] holeCards) {

		if (!sp.setHoleCards(holeCards)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
		if (!sp.setFinalPot(finalpot)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
		if (!sp.setCashDeltas(cashDelta)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
	}


	/*
	 * (non-Javadoc)
	 * @see game.gamestorage.IF_SetGameStorage#setEndCompetition(int[])
	 */
	@Override
	public void setEndCompetition(int[] ranking) {
		if (!sp.setRankings(ranking)) {
			System.err.println("ERROR in SetGameStorageTH_DB while filling db");
			return;
		}
	}


	/**
	 * @return true, if there is at least one connection to the db
	 */
	public boolean connectionSuccess() {

		return sp.connectionSuccess();
	}
}
