package game.gamestorage.texas;

import java.util.ArrayList;

import game.Action;
import game.gamestorage.IF_SetGameStorage;
import game.model.Card;

/**
 * This interface specifies all for Texas Holdem needed methods </br>
 * and extends the game independent methods by extending abstract interface IF_SetGameStorage
 * 
 * @author Witthold/Korol
 */
public interface IF_SetGameStorageTH extends IF_SetGameStorage {

	/**
	 * Stores information of the started hand.</br>
	 * 
	 * @param position
	 * 			Position of the player in this hand
	 * 			(0: first player behind the button; 1: second player behind the button; ...) - exact position at table
	 * @param sb - smallblind
	 * @param bb - bigblind
	 * @param ante - forced bet for all players
	 * @param cashInit - starting credits of every player
	 * @param holeCards - my holeCards as Card[]
	 */
	public void setHand(int[] position, int sb, int bb, int ante, int[] cashInit, Card[] holeCards); // called after first round of a hand


	/**
	 * Stores information of the ending round.</br>
	 * (if it is the last round of a hand, setEndHand will be called after this)</br>
	 * 
	 * @param timestamp as unix timestamp
	 * @param betHistory - all bets of this round
	 * @param revealedBoardCards (if revealed)
	 */
	public void setEndRound(long timestamp, ArrayList<Action> betHistory, Card[] revealedBoardCards); // called after each round	


	/**
	 * Stores information of the ending hand (winner, revealed holeCards, ...).</br>
	 * (no player actions)</br>
	 * 
	 * @param finalpot - total at the end of the hand
	 * @param cashDelta of every player: moneyBefore-moneyAfter
	 * @param enemyCards - if cards were shown
	 */
	public void setEndHand(int finalpot, int[] cashDelta, Card[][] enemyCards); // called after #SHOWDOWN message

}
